/**
* @file kVsSensorAdjust.x.h
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef K_VISION_VS_SENSOR_ADJUST_X_H
#define K_VISION_VS_SENSOR_ADJUST_X_H

#include <kApi/Data/kArrayList.h>
#include <kVision/L3d/kL3dUtilities.h>
#include <kApi/Data/kBytes.h>

/**
* Reserved kVsSensorAdjust macros.
*
* @relates kVsSensorAdjust
* @{ */
#define kVS_SENSOR_ADJUST_SCHEMA_VERSION        (1)
/** @} */


typedef struct kVsSensorAdjustCamera 
{
    k32s blackLevel;                  // k32S_NULL = not set
    k64f digitalGain;                 // k64F_NULL = not set
    k64f analogGain;                  // k64F_NULL = not set
    k64f exposureScale;               // k64F_NULL = not set
    k64f redGain;                     // k64F_NULL = not set
    k64f green0Gain;                  // k64F_NULL = not set
    k64f green1Gain;                  // k64F_NULL = not set
    k64f blueGain;                    // k64F_NULL = not set
    k32u tracheidThreshold;           // k32U_NULL = not set
    k32s x;                           // k32S_NULL = not set
    k32s y;                           // k32S_NULL = not set

} kVsSensorAdjustCamera;

typedef struct kVsSensorAdjustAnalogOutput 
{
    kBool isSet;
    k64f logicalMin;
    k64f logicalMax;
    k64f physicalMin;
    k64f physicalMax;

} kVsSensorAdjustAnalogOutput;

typedef struct kVsSensorAdjustProjector
{
    k64f maxIntensity;

} kVsSensorAdjustProjector;

typedef struct kVsSensorAdjustClass
{
    kObjectClass base;

    kArrayList cameras;
    kArrayList analogOutputs; //of type kVsSensorAdjustAnalogOutput
    kArrayList projectors;

} kVsSensorAdjustClass;

kDeclareClassEx(kVs, kVsSensorAdjust, kObject)

kStatus kVsSensorAdjust_Init(kVsSensorAdjust adjust, kAlloc allocator);
kStatus kVsSensorAdjust_Reset(kVsSensorAdjust adjust);
kStatus kVsSensorAdjust_ReadAnalog(kVsSensorAdjust adjust, kXml xml, kXmlItem item, kVsSensorAdjustAnalogOutput* output);
kVsFx(kStatus) kVsSensorAdjust_VRelease(kVsSensorAdjust adjust);
kVsFx(kBool) kVsSensorAdjust_VEquals(kVsSensorAdjust adjust, kVsSensorAdjust otherAdjust);
kVsFx(kStatus) kVsSensorAdjust_Read(kVsSensorAdjust adjust, kXml xml, kXmlItem root);
kVsFx(kStatus) kVsSensorAdjust_Write(kVsSensorAdjust adjust, kXml xml, kXmlItem root);

#endif /* #ifndef K_VISION_VS_SENSOR_ADJUST_X_H */

