#ifndef LMITECH_KVISION_VS_PRNUCAL_H_INCLUDED
#define LMITECH_KVISION_VS_PRNUCAL_H_INCLUDED

#include <kVision/L3d/kL3dUtilities.h>

#define kVS_PRNU_CAL_FILE_NAME_FORMAT    "PRNUCal%d.kdat"

typedef kObject kVsPrnuCal;

kVsFx(kStatus) kVsPrnuCal_Construct(kVsPrnuCal* cal, k32u stepCount, k32u imageWidth, k32u imageHeight, kAlloc allocator);
kVsFx(kStatus) kVsPrnuCal_LoadBinary(kVsPrnuCal *cal, kNode node, kChar *xmlFileName, kChar *binaryFileName, kAlloc allocator);
kVsFx(kStatus) kVsPrnuCal_Load(kVsPrnuCal *cal, kNode node, const kChar *fileName, kAlloc allocator);
kVsFx(kStatus) kVsPrnuCal_StoreBinary(kVsPrnuCal cal, kNode node, kChar *xmlFileName, kChar *binaryFileName);
kVsFx(kStatus) kVsPrnuCal_Store(kVsPrnuCal cal, kNode node, const kChar *filename);
kVsFx(kStatus) kVsPrnuCal_StoreV1(kVsPrnuCal cal, kNode node, const kChar *filename);

kVsFx(k32u) kVsPrnuCal_StepCount(kVsPrnuCal cal);
kVsFx(k32u) kVsPrnuCal_ImageWidth(kVsPrnuCal cal);
kVsFx(k32u) kVsPrnuCal_ImageHeight(kVsPrnuCal cal);

kVsFx(kStatus) kVsPrnuCal_SetBlackLevel(kVsPrnuCal cal, k32u blackLevel);
kVsFx(k32u) kVsPrnuCal_BlackLevel(kVsPrnuCal cal);

kVsFx(kStatus) kVsPrnuCal_SetGainDigital(kVsPrnuCal cal, k32u gain);
kVsFx(k32u) kVsPrnuCal_GainDigital(kVsPrnuCal cal);

kVsFx(kStatus) kVsPrnuCal_SetGainAnalog(kVsPrnuCal cal, k32u gain);
kVsFx(k32u) kVsPrnuCal_GainAnalog(kVsPrnuCal cal);

kVsFx(kStatus) kVsPrnuCal_SetWindow(kVsPrnuCal cal, const kL3dCameraWindow *window);
kVsFx(const kL3dCameraWindow*) kVsPrnuCal_Window(kVsPrnuCal cal);

kVsFx(kStatus) kVsPrnuCal_SetId(kVsPrnuCal cal, const kChar* id);
kVsFx(const kChar*) kVsPrnuCal_Id(kVsPrnuCal cal);

kVsFx(kStatus) kVsPrnuCal_SetTimestamp(kVsPrnuCal cal, const kChar *timestamp);
kVsFx(const kChar*) kVsPrnuCal_Timestamp(kVsPrnuCal cal);

kVsFx(kArray1) kVsPrnuCal_Positions(kVsPrnuCal cal);
kVsFx(kArray2) kVsPrnuCal_White(kVsPrnuCal cal, k32u stepIndex);
kVsFx(kArray2) kVsPrnuCal_Black(kVsPrnuCal cal, k32u stepIndex);

#include <kVision/Vs/kVsPrnuCal.x.h>

#endif  /* #ifndef LMITECH_KVISION_VS_PRNUCAL_H_INCLUDED */
