/**
 * @file    kVsMovingAvg.h
 * @brief   Declares the kVsMovingAvg class
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */

#ifndef K_VISION_MOVING_AVG_H
#define K_VISION_MOVING_AVG_H

#include <kVision/Vs/kVsImageFilter.h>

/**
* @class       kVsMovingAvg
* @extends     kVsImageFilter
* @ingroup     kVision-Vs
* @brief       An image filter class for performing an optimized 2D rolling average on images or 2D arrays using
*              a specified window size. The average for the window is set to null if the number of non-null pixels
*              in a window does not exceed or equal the parameter fillCount. The class supports k8u, k16s, k32s, and
*              k64f item types. Only kVS_IMAGE_FILTER_BORDER_TYPE_REPEAT is implemented. See kVsImageFilter for
*              setting additional algoritm parameters and use of kVsImageFilter_Setup and kVsImageFilter_Apply functions.
*
*/
typedef kVsImageFilter kVsMovingAvg;

/**
* Constructs a kVsMovingAvg object
*
* @public              @memberof kVsMovingAvg
* @param   filter      Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kVsMovingAvg_Construct(kVsMovingAvg* filter, kAlloc allocator);

#include <kVision/Vs/kVsMovingAvg.x.h>

#endif  /* K_VISION_MOVING_AVG_H */

