/** 
 * @file    kVsModelDef.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_VISION_MODEL_DEF_X_H
#define K_VISION_MODEL_DEF_X_H

#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kXml.h>
#include <kApi/Data/kMap.h>
#include <kApi/Io/kPath.h>
#include <kVision/Vs/kVsUtilities.h>
#include <kVision/Common/kVsLog.h>

#define kVS_MODELDEF_HEADER "ModelDef"
#define kSENSOR_IDENTITY_VERSION_ATTRIBUTE "schemaVersion"

#define kVS_MODELDEF_SYNTAX_NODE_CONTROLLER_TYPE                  "ControllerType"

typedef struct kVsModelDefClass 
{
    kObjectClass base;

    kArrayList fields[2];
} kVsModelDefClass;

kDeclareClassEx(kVs, kVsModelDef, kObject)

kVsFx(kStatus) kVsModelDef_VInitClone(kVsModelDef modelDef, kVsModelDef source, kAlloc allocator);
kVsFx(kStatus) kVsModelDef_VRelease(kVsModelDef modelDef);
kVsFx(kBool)   kVsModelDef_VEquals(kVsModelDef modelDef, kVsModelDef otherModelDef);

kStatus kVsModelDef_Init(kVsModelDef modelDef, kAlloc allocator);
kStatus kVsModelDef_FindValue(kVsModelDef modelDef, const kChar* name, kString* value);
kStatus kVsModelDef_AddOrReplaceField(kVsModelDef modelDef, const kChar* name, const kChar* value);

#endif  /* #ifndef K_VISION_INITIALIZER_X_H */
