/**
* @file    kVsJobQueue.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KVS_JOB_QUEUE_X_H
#define KVS_JOB_QUEUE_X_H

#include <kApi/Threads/kSemaphore.h>

#define kVS_JOB_QUEUE_MIN_DELAY_US      (1000)

typedef enum kVsJobQueueState
{
    kVS_JOB_QUEUE_STATE_IDLE,
    kVS_JOB_QUEUE_STATE_RUN,
    kVS_JOB_QUEUE_STATE_EXIT

} kVsJobQueueState;

typedef struct kVsJobQueueJob 
{
    kVsJobQueueEntry entry;
    kPointer entryContext;
    k64u id;
} kVsJobQueueJob;

typedef struct kVsJobQueueClass
{
    kObjectClass base;

    kArray1 threads;
    kMsgQueue jobQueue;

    // shared data

    kSemaphore activeSemaphore;

    kLock lock;
    kVsJobQueueState state;
    kStatus jobStatus;
    k32s activeCount;

} kVsJobQueueClass;

kDeclareClassEx(kVs, kVsJobQueue, kObject)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kVsJobQueue_VInitClone(kVsJobQueue queue, kVsJobQueue source, kAlloc allocator);
kVsFx(kStatus) kVsJobQueue_VRelease(kVsJobQueue queue);

//non-exported (private) methods
kStatus kVsJobQueue_Init(kVsJobQueue queue, kSize threadCount, kAlloc allocator);

kStatus kVsJobQueue_SetState(kVsJobQueue queue, kVsJobQueueState state);
kVsJobQueueState kVsJobQueue_State(kVsJobQueue queue);

kStatus kVsJobQueue_ClearJobStatus(kVsJobQueue queue);
kStatus kVsJobQueue_JobStatus(kVsJobQueue queue);
k32u kVsJobQueue_ActiveCount(kVsJobQueue queue);

kStatus kVsJobQueue_JobAdded(kVsJobQueue queue);
kStatus kVsJobQueue_JobCompleted(kVsJobQueue queue, kStatus jobStatus);

kStatus kCall kVsJobQueue_ThreadEntry(kPointer context);

//cast macro

#endif  /* #ifndef KVS_JOB_QUEUE_X_H */
