/**
* @file kVsImageStats.x.h
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef K_VISION_IMAGE_STATS_X_H
#define K_VISION_IMAGE_STATS_X_H

#include <kVision/Vs/kVsImageStats.h>

typedef struct kVsImageStatsClass
{
    kObjectClass base;

    kSize rawSpotPixelCount;
    kSize sortedSpotPixelCount;
    kSize rawSpotPixelSum;
    kSize sortedSpotPixelSum;
    kSize pixelSum;
    kSize rawSpotsCount;
    kSize sortedSpotsCount;
    kSize framePixelCount;
    kSize pseudoMedianIndex;
    kSize rawSpotCentreAverage;
    kSize sortedSpotCentreAverage;
    kSize rawMedian;
    kSize sortedMedian;
    kSize rawSpotAverageSum;
    kSize sortedSpotAverageSum;

} kVsImageStatsClass;

kDeclareClassEx(kVs, kVsImageStats, kObject)

kVsFx(kStatus) kVsImageStats_VRelease(kVsImageStats imageStats);
kVsFx(kStatus) kVsImageStats_VInitClone(kVsImageStats imageStats, kVsImageStats source, kAlloc allocator);
kStatus kVsImageStats_Init(kVsImageStats imageStats, kAlloc allocator);

#endif /* #ifndef K_VISION_IMAGE_STATS_X_H */