/**
* @file    kVsImageNoiseAlg.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KVS_IMAGE_NOISEALG_X_H
#define KVS_IMAGE_NOISEALG_X_H

#include <kVision/Vs/kVsMovingAvg.h>

#define kVS_IMAGE_NOISE_ALG_DEFAULT_ROI                      (1.0)
#define kVS_IMAGE_NOISE_ALG_DEFAULT_GROUND_SMOOTH_WINDOW     (0.25)

typedef struct kVsImageNoiseAlgClass
{
    kObjectClass base;

    kSize imageWidth;
    kSize imageHeight;

    kRect32s roiRect;
    k32s groundSmoothWindowPx;

    k64f roi;
    k64f groundSmoothWindow;

    kVsMovingAvg groundMovingAvg;


} kVsImageNoiseAlgClass;

kDeclareClassEx(kVs, kVsImageNoiseAlg, kObject)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kVsImageNoiseAlg_VInitClone(kVsImageNoiseAlg alg, kVsImageNoiseAlg source, kAlloc allocator);
kVsFx(kStatus) kVsImageNoiseAlg_VRelease(kVsImageNoiseAlg alg);

//non-exported (private) methods
kStatus kVsImageNoiseAlg_Init(kVsImageNoiseAlg alg, kAlloc allocator);

kStatus kVsImageNoiseAlg_ClipImageRoi(kVsImageNoiseAlg alg, kImage image);
kStatus kVsImageNoiseAlg_ClipAverageImageRoi(kVsImageNoiseAlg alg, kImage averageImage);
kStatus kVsImageNoiseAlg_ComputeAverageImage(kVsImageNoiseAlg alg, kImage* samples, kSize count, kImage averageImage);

//cast macro

#endif  /* #ifndef KVS_IMAGE_NOISEALG_X_H */
