#ifndef LMITECH_KVISION_VS_FPNCAL_H_INCLUDED
#define LMITECH_KVISION_VS_FPNCAL_H_INCLUDED

#include <kVision/L3d/kL3dUtilities.h>

#define kVS_FPN_CAL_FILE_NAME                        "FPNCal.kdat"

typedef kPointer kVsFpnCal;

kVsFx(kStatus) kVsFpnCal_Construct(kVsFpnCal* cal, k32u imageWidth, k32u imageHeight);
kVsFx(kStatus) kVsFpnCal_Load(kVsFpnCal* cal, kNode node, const kChar* fileName);
kVsFx(kStatus) kVsFpnCal_Store(kVsFpnCal cal, kNode node, const kChar* filename);
kVsFx(kStatus) kVsFpnCal_Destroy(kVsFpnCal cal);

kVsFx(k32u) kVsFpnCal_ImageWidth(kVsFpnCal cal);
kVsFx(k32u) kVsFpnCal_ImageHeight(kVsFpnCal cal);

kVsFx(kStatus) kVsFpnCal_SetBlackLevel(kVsFpnCal cal, k32u blackLevel);
kVsFx(k32u) kVsFpnCal_BlackLevel(kVsFpnCal cal);

kVsFx(kStatus) kVsFpnCal_SetGainDigital(kVsFpnCal cal, k32u gain);
kVsFx(k32u) kVsFpnCal_GainDigital(kVsFpnCal cal);

kVsFx(kStatus) kVsFpnCal_SetGainAnalog(kVsFpnCal cal, k32u gain);
kVsFx(k32u) kVsFpnCal_GainAnalog(kVsFpnCal cal);

kVsFx(kStatus) kVsFpnCal_SetWindow(kVsFpnCal cal, const kL3dCameraWindow* window);
kVsFx(const kL3dCameraWindow*) kVsFpnCal_Window(kVsFpnCal cal);

kVsFx(kStatus) kVsFpnCal_SetId(kVsFpnCal cal, const kChar* id);
kVsFx(const kChar*) kVsFpnCal_Id(kVsFpnCal cal);

kVsFx(kStatus) kVsFpnCal_SetTimestamp(kVsFpnCal cal, const kChar* timestamp);
kVsFx(const kChar*) kVsFpnCal_Timestamp(kVsFpnCal cal);

kVsFx(kArray2) kVsFpnCal_Offsets(kVsFpnCal cal);

#endif  /* #ifndef LMITECH_KVISION_VS_FPNCAL_H_INCLUDED */
