/** 
 * @file    kVsFpnActionInfo.h
 * @brief   Declares the kVsFpnActionInfo class. 
 * 
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_VS_FPN_ACTION_INFO_H_INCLUDED
#define LMITECH_KVISION_VS_FPN_ACTION_INFO_H_INCLUDED

#include <kVision/Common/kVision.h>
#include <kApi/Data/kXml.h>
#include <kVision/L3d/kL3dTransform2d.h>

/**
 * @class   kVsFpnActionInfo
 * @ingroup kVision
 * @brief   Settings for kVsFpnAction.
 */
typedef kObject kVsFpnActionInfo; 

kVsFx(kStatus) kVsFpnActionInfo_Construct(kVsFpnActionInfo* info, kAlloc allocator);

kVsFx(kStatus) kVsFpnActionInfo_Load(kVsFpnActionInfo* info, kXml xml, kAlloc allocator);
kVsFx(kStatus) kVsFpnActionInfo_Store(kVsFpnActionInfo info, kXml* xml, kAlloc allocator);

kVsFx(kStatus) kVsFpnActionInfo_Write(kVsFpnActionInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kVsFpnActionInfo_Read(kVsFpnActionInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kVsFpnActionInfo_Clear(kVsFpnActionInfo info); 
kVsFx(kStatus) kVsFpnActionInfo_Validate(kVsFpnActionInfo info); 

kVsFx(k32u) kVsFpnActionInfo_ViewIndex(kVsFpnActionInfo info);
kVsFx(kStatus) kVsFpnActionInfo_SetViewIndex(kVsFpnActionInfo info, k32u index);

kVsFx(const kChar*) kVsFpnActionInfo_CalFileName(kVsFpnActionInfo info);
kVsFx(kStatus) kVsFpnActionInfo_SetCalFileName(kVsFpnActionInfo info, const kChar* calFileName);

#include <kVision/Vs/kVsFpnActionInfo.x.h>

#endif
