/**
* @file    kVsBlowfish.h
* @brief   Declares the kVsBlowfish class.
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef K_VISION_BLOWFISH_H
#define K_VISION_BLOWFISH_H

#include <kVision/Common/kVision.h>

/**
* @class       kVsBlowfish
* @extends     kObject
* @ingroup     kVision-Vs
* @brief       kVision implementation of the Blowfish cypher.
*/
typedef kObject kVsBlowfish;

/**
* Constructs a kVsBlowfish object.
*
* @public                   @memberof kVsBlowfish
* @param   blowfish         Destination for the constructed object handle.
* @param   key              Encryption key.
* @param   length           Length of encryption key.
* @param   allocator        Memory allocator (or kNULL for default).
* @return                   Operation status.
*/
kVsFx(kStatus) kVsBlowfish_Construct(kVsBlowfish* blowfish, kByte* key, kSize length, kAlloc allocator);

/**
* Encrypts a 64-bit message block.
*
* @public                   @memberof kVsBlowfish
* @param   blowfish         kVsBlowfish object.
* @param   left             Left partition (32-bits).
* @param   right            Right partition (32-bits).
* @param   leftOut          Encrypted left partition.
* @param   rightOut         Encrypted right partition.
* @return                   Operation status.
*/
kVsFx(kStatus) kVsBlowfish_Encrypt(kVsBlowfish blowfish, const k32u* left, const k32u* right, k32u* leftOut, k32u* rightOut);

/**
* Decrypts a 64-bit message block.
*
* @public                   @memberof kVsBlowfish
* @param   blowfish         kVsBlowfish object.
* @param   left             Left partition (32-bits).
* @param   right            Right partition (32-bits).
* @param   leftOut          Decrypted left partition.
* @param   rightOut         Decrypted right partition.
* @return                   Operation status.
*/
kVsFx(kStatus) kVsBlowfish_Decrypt(kVsBlowfish blowfish, const k32u* left, const k32u* right, k32u* leftOut, k32u* rightOut);

#include <kVision/Vs/kVsBlowfish.x.h>

#endif  /* K_VISION_BLOWFISH_H */
