/**
* @file    kS3dVolumeCheckValveAlg.x.h
* @brief   Declares the kS3dVolumeCheckValveAlg class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKVALVE_X_H
#define KVISION_KS3D_VOLUMECHECKVALVE_X_H

typedef struct kS3dVolumeCheckValveAlgClass
{
    kObjectClass base;

    kS3dVolumeCheckSubPixLut  subPixLut;
    kPoint3d64f center;      

    k64f        polarAngle;   
    k64f        slopeAngle;   
    k64f        diameter;     
    k64f        zRange;       
    k64f        searchStep;   
    k64f        radiusFactor;
    k64f        ringPhaseThick;
    k64f        rangeScale;   
    k8u         segmentBit;
    kS3dVolumeCheckValveSoftwareCoverMode  softCover;
    k32s        measureIndex;  

    k64f        xyScale;
    k16u        scaleShift;
    kArray2      map;
    kArray2      profileMapOrg;
    kArray2      profileMap;
    kArray1   ringPosition;
    kArray1   ringRadius;
    kArray1   ringHistogram;
    k32s      ringCount;

    k32s dXX, dXY, dXZ;
    k32s dYX, dYY, dYZ;
    k32s dZX, dZY, dZZ;

    k32s lineLen;   
    k32s lineCount; 
    kBool changed;  

    k32s centerX; 
    k32s centerY; 
    k32s centerZ; 
    k32s centerR2;  
    k32s nominalR2;  

    k32s startX;  
    k32s endX;    
    k32s startY;  
    k32s endY;    
    k32s mask;
    k32s zStep;
    k32s zPos;
    k32s zR2;
    k32s zmin, zmax;

    k32s holeCount; 
    k32s minR;      
    k32s minRBack;  

    kBool       valveHoleExists;
    kPoint3d64f  actualCenter;
    kPoint3d64f localCenter;
    k64f        aveDifference;
    k64f        ringGaps;
    k32s x0, y0, z0;
    k32s targetR;   
    kArrayList seatRingprofileX;
    kArrayList seatRingprofileY;
    kArrayList seatRingprofileZ;
} kS3dVolumeCheckValveAlgClass;

kDeclareClassEx(kVs, kS3dVolumeCheckValveAlg, kObject)

kStatus kS3dVolumeCheckValveAlg_Init(kS3dVolumeCheckValveAlg valve, kType classType, kS3dVolumeCheckSubPixLut subPixLut, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckValveAlg_VRelease(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_SetTransformCoeffs(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_CreateHeightMap(kS3dVolumeCheckValveAlg valve, kS3dVolumeCheckAlign align);
kStatus kS3dVolumeCheckValveAlg_CheckValveHole(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_ExpandValveHole(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_ExpandValveHoleOnce(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_EvaluateSeatRing(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_DrawValveSeatRingMap(kS3dVolumeCheckValveAlg valve, k32s step);
kStatus kS3dVolumeCheckValveAlg_SetAverageSeatRingCenter(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_FitValveSeatRingMap(kS3dVolumeCheckValveAlg valve, k32s step);
kStatus kS3dVolumeCheckValveAlg_CalculateActualCenter(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_RescaleSeatRingMap(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_SegmentSeatRingMap(kS3dVolumeCheckValveAlg valve, kS3dVolumeCheckAlign align);
kStatus kS3dVolumeCheckValveAlg_ResetValveHoleArea(kS3dVolumeCheckValveAlg valve, kArray2 output, kArray2 weight, k64f xyScale);
kStatus kS3dVolumeCheckValveAlg_InitValveSeatRingMap(kS3dVolumeCheckValveAlg valve);
kStatus kS3dVolumeCheckValveAlg_SetSeatRingProfile(kS3dVolumeCheckValveAlg valve);

#define kS3DVOLUMECHECKVALVEALG(HANDLE) ((kS3dVolumeCheckValveAlgClass*)(HANDLE))

#endif /* #ifndef KVISION_KS3D_VOLUMECHECKVALVE_X_H */  
