/**
* @file    kS3dVolumeCheckSubPixLut.x.h
* @brief   Declares the kS3dVolumeCheckSubPixLut class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKSUBPIXLUT_X_H
#define KVISION_KS3D_VOLUMECHECKSUBPIXLUT_X_H

typedef struct kS3dVolumeCheckSubPixLutClass
{
    kObjectClass base;
    kArray1 data;  
    k32f  sigma;   
    k16u window;  
    k16u width;   
    k16u widthShift;
    k16u weightPow; 
    k16s maxValue;
    k16s threshold;
    kBool changed;
}kS3dVolumeCheckSubPixLutClass;


kDeclareClassEx(kVs, kS3dVolumeCheckSubPixLut, kObject)

kStatus kS3dVolumeCheckSubPixLut_Init(kS3dVolumeCheckSubPixLut lut, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckSubPixLut_VRelease(kS3dVolumeCheckSubPixLut lut);

#define KS3DVOLUMECHECKSUBPIXLUT(HANDLE) ((kS3dVolumeCheckSubPixLutClass*)(HANDLE))

#endif  /* #ifndef KVISION_KS3D_VOLUMECHECKSUBPIXLUT_X_H */ 
