/**
* @file    kS3dVolumeCheckDef.h
* @brief   Essential kS3dVolumeCheck declarations.
*
* @internal
* Copyright(C) 2016-2022 by LMI Technologies Inc.All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECK_DEF_H
#define KVISION_KS3D_VOLUMECHECK_DEF_H

#include <kApi/kApiDef.h>
#include <kApi/kAlloc.h>

#define kS3D_VOLUMECHECK_DEFAUT_VALVE_COUNT (4)
#define kS3D_VOLUMECHECK_DEFAUT_SPARK_COUNT (2)

#define kS3D_VOLUMECHECK_FILTERING_MAX (2)
#define kS3D_VOLUMECHECK_VALVE_MAX     (8) 

#define kS3D_VOLUMECHECK_DEFAUT_SEARCH_LENGTH (2)
#define kS3D_VOLUMECHECK_DEFAUT_SEATRING_THICK (1.4)

#define kS3D_VOLUMECHECK_MAXIMUM_ALIGN_REPEAT     (5) 
#define kS3D_VOLUMECHECK_MAXIMUM_ROTATION_REPEAT  (3) 
#define kS3D_VOLUMECHECK_ROTATION_TOLERANCE  (0.01) 
#define kS3D_VOLUMECHECK_MOVE_TOLERANCE  (0.005) 

#define kS3D_VOLUMECHECK_DEFAULT_NOMINALVOLUME   (43.5)
#define kS3D_VOLUMECHECK_DEFAULT_VOLUMETOLERANCE  (0.3)


#define kS3D_VOLUMECHECK_VOLUME_OFFSET  (0)
#define kS3D_VOLUMECHECK_VOLUME_CORRECT_FACTOR   (1)
#define kS3D_VOLUMECHECK_MAXIMUM_DEPTH  (-20)
#define kS3D_VOLUMECHECK_VALVE_SEARCH_STEP  (0.01)
#define kS3D_VOLUMECHECK_VALVE_WINDOW_FACTOR  (1.4)
#define kS3D_VOLUMECHECK_VALVE_IMAGESIZE_MIN  (360)

#define kS3D_VOLUMECHECK_OUTLIER_LIMIT (0.5) 
#define kS3DVOLUMECHECKALIGN_OUTLIER_FILTER_WINDOW (11)
#define kS3DVOLUMECHECKALIGN_OUTLIER_FILTER_REPEAT (3)
#define kS3DVOLUMECHECKALIGN_OUTLIER_FILTER_USED  (kTRUE)

#define kS3DVOLUMECHECKALIGN_SMOOTH_FILTER_WINDOW (5)
#define kS3DVOLUMECHECKALIGN_SMOOTH_FILTER_REPEAT (2)
#define kS3DVOLUMECHECKALIGN_SMOOTH_FILTER_USED  (kTRUE)

#define kS3DVOLUMECHECK_CONTOUR_AVERAGE_WINDOW (10)

#define kS3DVOLUMECHECK_OUTPUT_SIZEX       (1000)
#define kS3DVOLUMECHECK_OUTPUT_SIZEY       (1000)
#define kS3DVOLUMECHECK_OUTPUT_XYSCALE     (0.1)

#define KS3DVOLUMECHECKALIGN_16TO32_SHIFT   (3)
#define KS3DVOLUMECHECKALIGN_Z_TO_XY_SHIFT  (8)
#define KS3DVOLUMECHECKALIGN_DEFAULT_RANGE_RESOLUTION16S  (0.0025) 

#define KS3DVOLUMECHECKALIGN_ALIGN_SHIFT            (15)
#define KS3DVOLUMECHECKALIGN_ALIGN_SCALE            (1 << KS3DVOLUMECHECKALIGN_ALIGN_SHIFT)

#define KS3DVOLUMECHECKALIGN_MOVE_SHIFT            (7)
#define KS3DVOLUMECHECKALIGN_MOVE_SCALE            (1 << KS3DVOLUMECHECKALIGN_MOVE_SHIFT)

#define kS3D_VOLUMECHECK_FILLE_REMAIN_HOLE_MAX_REPEAT (16)

#define kS3DVOLUMECHECK_OUTPUT_ZRESOLUTION (0.0003125)  // 1 / 

#define kS3DVOLUMECHECK_WARN_ALIGN_INSTABILITY         (1)
#define kS3DVOLUMECHECK_WARN_BORDER_DETECTION_FAILURE  (2)

typedef enum kS3dVolumeCheckDefaultChamberType
{
    kS3D_DEFAULT_CHAMBER_UNKNOWN = 0,
    kS3D_DEFAULT_CHAMBER_TYPE_ONE,
    kS3D_DEFAULT_CHAMBER_TYPE_TWO,
    kS3D_DEFAULT_CHAMBER_TYPE_THREE,
    kS3D_DEFAULT_CHAMBER_TYPE_MASTER,
    kS3D_DEFAULT_CHAMBER_END
} kS3dVolumeCheckDefaultChamberType;

typedef enum kS3dVolumeCheckSensorRotationMode
{
    kS3D_ORIGINAL_ORIENTATION=0,
    kS3D_HORIZONTAL_FLIP,
    kS3D_VERTICAL_FLIP,
    kS3D_ROTATE_180,
    kS3D_FLIPPED_ROTATE_90_LEFT,
    kS3D_ROTATE_90_LEFT,
    kS3D_FLIPPED_ROTATE_90_RIGHT,
    kS3D_ROTATE_90_RIGHT
}kS3dVolumeCheckSensorRotationMode;

typedef enum kS3dVolumeCheckValveSoftwareCoverMode
{
    kS3D_VALVE_COVER_NOT_USED = 0,
    kS3D_VALVE_COVER_AFTER_NOMINAL_RADIUS=1,
    kS3D_VALVE_COVER_AFTER_NOMINAL_HEIGHT,
    kS3D_VALVE_COVER_AFTER_NOMINAL_POSITION
}kS3dVolumeCheckValveSoftwareCoverMode;

typedef struct kS3dValveSettings
{
    kPoint3d64f center;         
    k64f        ringPhaseThick; 
    k64f        polarAngle;     
    k64f        slopeAngle;     
    k64f        diameter;       
    k64f        zRange;         
    kS3dVolumeCheckValveSoftwareCoverMode  softCover;
} kS3dValveSettings;

typedef struct kS3dVolumeCheckFilteringParams
{
    k32u  window;
    k32u  repeat;
    k64f  tolerance;
    kBool used;
} kS3dVolumeCheckFilteringParams;

typedef enum kS3dVolumeCheckSurfaceFrameOfReferenceType
{
    kS3D_VOLUMECHECK_FOR_TYPE_SENSOR = 0,
    kS3D_VOLUMECHECK_FOR_TYPE_SCAN = 1,
    kS3D_VOLUMECHECK_FOR_TYPE_SOURCEPART = 3,
    kS3D_VOLUMECHECK_FOR_TYPE_PART = 2
} kS3dVolumeCheckSurfaceFrameOfReferenceType;

typedef enum kS3dVolumeCheckInputFormatType
{
    kS3D_VOLUMECHECK_INPUT_ARRAY2 = 0,
    kS3D_VOLUMECHECK_INPUT_OMC_TO_POINT3D16S = 1,
    kS3D_VOLUMECHECK_INPUT_OMC_TO_POINT3D32S,
    kS3D_VOLUMECHECK_INPUT_OMC_TO_POINT3D32F,
    kS3D_VOLUMECHECK_INPUT_OMC_TO_POINT3D64F,
    kS3D_VOLUMECHECK_INPUT_OMC_TO_K16S,
    kS3D_VOLUMECHECK_INPUT_OMC_TO_K32S,
    kS3D_VOLUMECHECK_INPUT_OMC_TO_K32F,
    kS3D_VOLUMECHECK_INPUT_OMC_TO_K64F,
    kS3D_VOLUMECHECK_INPUT_END
}kS3dVolumeCheckInputFormatType;


#define kS3D_VOLUMECHECKER_RANDOMAMPLITUDE_X (10)
#define kS3D_VOLUMECHECKER_RANDOMAMPLITUDE_Y (10)
#define kS3D_VOLUMECHECKER_RANDOMAMPLITUDE_Z (8)
#define kS3D_VOLUMECHECKER_RANDOMAMPLITUDE_A (5)
#define kS3D_VOLUMECHECKER_RANDOMAMPLITUDE_B (360)
#define kS3D_VOLUMECHECKER_RANDOMAMPLITUDE_C (5)

#endif /* #ifndef KVISION_KS3D_VOLUMECHECK_DEF_H */
