#ifndef LMITECH_KVISION_S3D_UTILITIES_H_INCLUDED
#define LMITECH_KVISION_S3D_UTILITIES_H_INCLUDED

#include <kVision/Common/kMatrix.h>
#include <kVision/S3d/kS3dCommon.h>
#include <kVision/L3d/kL3dTransform3d.h>

#define kS3D_MATH_DOT_3D(P0,P1)      ((P0)->x * (P1)->x + (P0)->y * (P1)->y + (P0)->z * (P1)->z)
#define kS3D_MATH_NORM_3D(P)         (sqrt(kS3D_MATH_NORM_SQ_3D(P)))
#define kS3D_MATH_NORM_SQ_3D(P)      (kS3D_MATH_DOT_3D(P,P))
#define kS3D_MATH_DIST_SQ_3D(P0,P1)  (((P0)->x - (P1)->x)*((P0)->x - (P1)->x) + ((P0)->y - (P1)->y)*((P0)->y - (P1)->y) + ((P0)->z - (P1)->z)*((P0)->z - (P1)->z))
#define kS3D_MATH_DIST_3D(P0,P1)     (sqrt(kS3D_MATH_DIST_SQ_3D(P0,P1)))

kVsFx(const kChar*) kS3dStripeLookupType_Name(kS3dStripeLookupType lookupType);

kVsFx(kStatus) kS3dLine3d_NearestApproach64f(const kLine3d64f* l0, const kLine3d64f* l1, kPoint3d64f* p, k64f* distance);
kVsFx(kStatus) kS3dMathLine3d_Fit64f(const k64f* x, const k64f* y, const k64f* z, kSize count, kLine3d64f* l);
kVsFx(kStatus) kS3dMathLine3d_FromAngles(kPoint3d64f p, k64f yaw, k64f pitch, kLine3d64f* l);
kVsFx(kStatus) kS3dMathLine3d_Angles64f(const kLine3d64f* l, k64f* pitch, k64f* yaw);
kVsFx(kStatus) kS3dMathLine3d_ProjectXy64f(const kLine3d64f* l, k64f z, k64f* x, k64f* y);

kVsFx(kStatus) kS3dRanges_SubtractPoints64f(const kPoint3d64f* aIter, const kPoint3d64f* bIter, kSize count, kPoint3d64f* outIter);
kVsFx(kStatus) kS3dRanges_DividePoints64f(const kPoint3d64f* aIter, const kPoint3d64f* bIter, kSize count, kPoint3d64f* outIter);
kVsFx(kStatus) kS3dRanges_DescriptiveStatsPoints64f(const kPoint3d64f* inIter, kSize count, kPoint3d64f* mean, kPoint3d64f* stddev, kSize* validCount, kSize* nullCount, kPoint3d64f* minMagnitude, kPoint3d64f* maxMagnitude);

kVsFx(kStatus) kS3dRanges_CorrectExpansion(const kPoint3d16s* inIter, k32u count, k64f resol, k64f dt, k64f coeffAl, k64f standOff, kPoint3d16s* outIter);

kVsFx(kStatus)      kS3dMath_ComplexCubic(const k64f a2, const k64f a1, const k64f a0, kComplex* root);
kVsFx(kStatus)      kS3dMath_ComplexQuartic(const k64f a3, const k64f a2, const k64f a1, const k64f a0, kComplex* root);
kVsFx(kStatus)      kS3dMath_ComplexSqrt(const kComplex* a, kComplex* b);
kVsFx(kStatus)      kS3dMath_CramersRule3x3(const k64f* lhs, const k64f* rhs, k64f* sol);
kVsFx(kPoint3d64f)  kS3dMath_CrossProduct3d(const kPoint3d64f* v0, const kPoint3d64f* v1);
kVsFx(k64f)         kS3dMath_Det3x3(const k64f* mat);
kVsFx(k64f)         kS3dMath_DistPointToLine(const kPoint3d64f* p, const kPoint3d64f* l1, const kPoint3d64f* l2);
kVsFx(kStatus)      kS3dMath_Normalize64f(kPoint3d64f* p);
kVsFx(kStatus)      kS3dMath_QuatToEuler(const kQuat* quat, k64f* ry, k64f* rz, k64f* rx);
kVsFx(kStatus)      kS3dMath_QuatFromMatrix(kQuat* quat, const k64f* mat);
kVsFx(kStatus)      kS3dMath_QuatFromTransform(kQuat* quat, const kL3dTransform3d* transform);
kVsFx(kPoint3d64f)  kS3dMath_QuatMul3d(const kQuat* quat, const kPoint3d64f* p);
kVsFx(kQuat)        kS3dMath_QuatProduct(const kQuat* a, const kQuat* b);

kVsFx(kStatus)      kS3dPlane3d_FitPoint64f(const kPoint3d64f* points, k32u count, kPlane3d64f* result);
kVsFx(kStatus)      kS3dPlane3d_Fit64f(const k64f* x, const k64f* y, const k64f* z, k32u count, kPlane3d64f* result);
kVsFx(kStatus)      kS3dPlane3d_Params64f(const kPlane3d64f* plane, k64f* origin, k64f* pitch, k64f* yaw);
kVsFx(kStatus)      kS3dPlane3d_FromParams64f(kPlane3d64f* plane, k64f origin, k64f pitch, k64f yaw);
kVsFx(kStatus)      kS3dPlane3d_OriginEuler64f(const kPlane3d64f* plane, k64f* origin, k64f* pitch, k64f* roll, k64f* yaw);
kVsFx(kStatus)      kS3dPlane3d_FromOriginEuler64f(kPlane3d64f* plane, k64f origin, k64f pitch, k64f roll, k64f yaw);
kVsFx(kStatus)      kS3dPlane3d_ZErrorPoint64f(const kPlane3d64f* plane, kPoint3d64f* points, k32u count, k64f* zError);
kVsFx(kStatus)      kS3dPlane3d_Evaluate64f(const kPlane3d64f* plane, k64f x, k64f y, k64f* z);

/**
 * Extracts the raw intensity data from the phaseMap
 * @param phaseMap A kArray2<kPhasePixel>, presumably coming from the PL
 * @param intensity A kArray2<k16s> intensity image will be allocated at the specified location
**/
kVsFx(kStatus)      kS3dPhaseMap_Intensity(kArray2 phaseMap, kArray2* intensity, kAlloc alloc);

/**
 * Accumulates the values in intensity into the sum array, and increments the count array for every pixel
 * that had a valid intensity
 * @param intensity kArray2<k16s>, presumably from kS3dPhaseMap_Intensity
 * @param sum kArray2<k32s>, size matching intensity array. Should be zeroed before first accumulation
 * @param count kArray2<k32s>, size matching intensity array. Should be zeroed before first accumulation
**/
kVsFx(kStatus)      kS3dIntensity_Accumulate(kArray2 intensity, kArray2 sum, kArray2 count);

/**
* Calculates the index of a Gray code bitmask value in the Gray code sequence
*
* @param   value            Gray code Value
* @param   bitDepth         Number of bits in the Gray code sequence
* @return                   Square distance
*/

kSize kS3dGrayCode_ToBinary(kSize value, kSize bitDepth);

///@brief Populates a code conversion lut (gray code -> binary) for use in PL programming. Outputs kArray2<k32s> with
/// length equal to 2^bitDepth
kVsFx(kStatus) kS3dStripe_PlCodeLut(kArray1* codeLut, kSize bitDepth, kAlloc alloc);

///@brief Populates a code conversion lut (gray code -> binary) for use in PL programming. Outputs kArray2<k32s> with
/// length equal to patternCount. To match the precision of the software implementation, the precision parameter
/// should be set to kS3D_PHASE_SINE_LUT_SHIFT
kVsFx(kStatus) kS3dPhase_PlSinCosLuts(kArray1* sinLut, kArray1* cosLut, kSize patternCount, kSize precision, kAlloc alloc);

/**
 * Calculates square distance between two points.
 *
 * @param   point0           First point
 * @param   point0           Second point
 * @return                   Square distance
 */

kCudaInlineFx(k64u) kS3dMath_SqrDistancePoint3d16s(const kPoint3d16s *point0, const kPoint3d16s *point1);

/**
 * Calculates linear interpolation between 2 points.
 * New Point = point0 * scalar + point1 * (1 - scalar)
 *
 * @param   point0           First point
 * @param   point0           Second point
 * @param   scalar           Interpolation value [0, k16U_MAX] mapping to [0, 1]
 * @return                   New point
 */

kInlineFx(kPoint3d16s) kS3dMath_LinearInterpolationPoint3d16s(const kPoint3d16s *point0, const kPoint3d16s *point1, k32u fraction);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

/**
* Produces a plot from kArray2<kPhasePixel> by plotting phase value, intensity and contrast as individual layers 
*
* @param   phaseMap         kArray2<kPhasePixel>
* @param   plot             Output pointer to a result plot rendering individual fields in kPhasePixel value as layers
* @return                   New point
*/

kVsFx(kStatus) kS3dPhaseMap_Plot(kArray2 phaseMap, kPlot* plot, kAlloc allocator);

#include <kVision/S3d/kS3dUtilities.x.h>

#endif /* #ifndef LMITECH_KVISION_S3D_UTILITIES_H_INCLUDED */
