/**
* @file    kS3dStripeDecoder.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef kS3D_STRIPE_DECODER_X_H
#define kS3D_STRIPE_DECODER_X_H

#define kS3D_STRIPE_DECODER_DEFAULT_CONTRAST_THRESHOLD    (10)

typedef struct kS3dStripeDecoderClass
{
    kObjectClass base;

    // Algorithm parameters
    kSize imageWidth;
    kSize imageHeight;
    kSize stripeImageCount;
    kSize contrastThreshold;

    kArray1 grayLut;
    kArray2 referenceBuffer;

    kSize lutStripeImageCount;
    kSize acquiredMask;

    kArray2 output;

} kS3dStripeDecoderClass;

kDeclareClassEx(kVs, kS3dStripeDecoder, kObject)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kS3dStripeDecoder_VInitClone(kS3dStripeDecoder decoder, kS3dStripeDecoder source, kAlloc allocator);
kVsFx(kStatus) kS3dStripeDecoder_VRelease(kS3dStripeDecoder decoder);
kVsFx(kSize)   kS3dStripeDecoder_VSize(kS3dStripeDecoder decoder);

//non-exported (private) methods
kStatus kS3dStripeDecoder_Init(kS3dStripeDecoder decoder, kAlloc allocator);

//cast macro

#endif  /* #ifndef kS3D_STRIPE_DECODER_X_H */
