#ifndef LMITECH_KVISION_S3D_STEREOPROFILER_DEP_X_H_INCLUDED
#define LMITECH_KVISION_S3D_STEREOPROFILER_DEP_X_H_INCLUDED

#include <kVision/L3d/kL3dUtilities.h>
#include <kVision/S3d/kS3dMonoMergeAlg.h>
#include <kVision/S3d/kS3dMonoMergeLocalAlg.h>
#include <kFireSync/Data/kSpot.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kArray3.h>
#include <kApi/Data/kMath.h>
#include <math.h>

#define kS3D_STEREO_PROFILER_DEP_DELTA_SHIFT            (15)
#define kS3D_STEREO_PROFILER_DEP_DELTA_SCALE            (1 << kS3D_STEREO_PROFILER_DEP_DELTA_SHIFT)
#define kS3D_STEREO_PROFILER_DEP_MERGE_STEP             (8)
#define kS3D_STEREO_PROFILER_DEP_MERGE_FLUSH_INTERVAL   (10000)
#define kS3D_STEREO_PROFILER_DEP_MERGE_MIN_POINTS       (100)   // 100 points
#define kS3D_STEREO_PROFILER_DEP_MERGE_MIN_POINTS_TOL   (0.001) // 0.1%

typedef enum
{
    kS3D_DELTA_ACCUM_U,    
    kS3D_DELTA_ACCUM_V,    
    kS3D_DELTA_ACCUM_UU,    
    kS3D_DELTA_ACCUM_VV,    
    kS3D_DELTA_ACCUM_UV,    

    kS3D_DELTA_ACCUM_DXU,    
    kS3D_DELTA_ACCUM_DXV,    
    kS3D_DELTA_ACCUM_DX,    

    kS3D_DELTA_ACCUM_DYU,    
    kS3D_DELTA_ACCUM_DYV,    
    kS3D_DELTA_ACCUM_DY,    

    kS3D_DELTA_ACCUM_DZU,    
    kS3D_DELTA_ACCUM_DZV,    
    kS3D_DELTA_ACCUM_DZ,

    kS3D_DELTA_ACCUM_COUNT

} kS3dStereoProfilerDepDeltaAccum;

typedef struct kS3dPhaseDeltaDepFunction
{
    k64f accumf[kS3D_DELTA_ACCUM_COUNT];  
    k64s accum[kS3D_DELTA_ACCUM_COUNT];  

    k64s n;

    // delta plane fit coefficients

    k64f coeffsDx[3];
    k64f coeffsDy[3];
    k64f coeffsDz[3];

    k32s coeffsDxi[3];
    k32s coeffsDyi[3];
    k32s coeffsDzi[3];

} kS3dPhaseDeltaDepFunction;

#define kxS3D_STEREO_PROFILER_DEP_INTERP(V0, V1, FRACT, SHIFT, ROUND)   ((V0) + ((((V1) - (V0)) * (FRACT) + (ROUND)) >> (SHIFT)))

#define kxS3D_STEREO_PROFILER_DEP_INTERP_PROJ_LIN(OBJ, P0, P1, FRACT, SHIFT, ROUND, OUT)\
do\
{\
    if((P0)->x != k16S_NULL && (P1)->x != k16S_NULL)\
        {\
        (OUT)->x = (k16s)kxS3D_STEREO_PROFILER_DEP_INTERP((P0)->x, (P1)->x, (FRACT), (SHIFT), (ROUND));\
        (OUT)->y = (k16s)kxS3D_STEREO_PROFILER_DEP_INTERP((P0)->y, (P1)->y, (FRACT), (SHIFT), (ROUND));\
        }\
        else\
    {\
        (OUT)->x = (OUT)->y = k16S_NULL;\
    }\
}\
    while(0);\

#define kxS3D_STEREO_PROFILER_DEP_INTERP_PROJ_BILIN(OBJ, P00, P01, P10, P11, X, Y, OUT)\
do\
{\
    kPoint3d16s bilinTemp[2];\
    kxS3D_STEREO_PROFILER_DEP_INTERP_PROJ_LIN((OBJ), (P00), (P01), (X), (OBJ)->projXShift, (OBJ)->projXRound, &bilinTemp[0]);\
    kxS3D_STEREO_PROFILER_DEP_INTERP_PROJ_LIN((OBJ), (P10), (P11), (X), (OBJ)->projXShift, (OBJ)->projXRound, &bilinTemp[1]);\
    if(bilinTemp[0].x != k16S_NULL && bilinTemp[1].x != k16S_NULL)\
        {\
        kxS3D_STEREO_PROFILER_DEP_INTERP_PROJ_LIN((OBJ), &bilinTemp[0], &bilinTemp[1], (Y), (OBJ)->projYShift, (OBJ)->projYRound, (OUT));\
        }\
        else\
    {\
        (OUT)->x = (OUT)->y = k16S_NULL;\
    }\
} while(0);\

#define kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_LIN(OBJ, P0, P1, FRACT, SHIFT, ROUND, OUT)\
do\
{\
    if((P0)->x != k16S_NULL && (P1)->x != k16S_NULL)\
        {\
        (OUT)->x = (k16s)kxS3D_STEREO_PROFILER_DEP_INTERP((P0)->x, (P1)->x, (FRACT), (SHIFT), (ROUND));\
        (OUT)->y = (k16s)kxS3D_STEREO_PROFILER_DEP_INTERP((P0)->y, (P1)->y, (FRACT), (SHIFT), (ROUND));\
        (OUT)->z = (k16s)kxS3D_STEREO_PROFILER_DEP_INTERP((P0)->z, (P1)->z, (FRACT), (SHIFT), (ROUND));\
        }\
        else\
    {\
        (OUT)->x = (OUT)->y = (OUT)->z = k16S_NULL;\
    }\
}\
    while(0);\

#define kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_BILIN(OBJ, P00, P01, P10, P11, X, Y, OUT)\
do\
{\
    kPoint3d16s bilinTemp[2];\
    kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_LIN(OBJ, (P00), (P01), (X), (OBJ)->dispXShift, (OBJ)->dispXRound, &bilinTemp[0]);\
    kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_LIN(OBJ, (P10), (P11), (X), (OBJ)->dispXShift, (OBJ)->dispXRound, &bilinTemp[1]);\
    if(bilinTemp[0].x != k16S_NULL && bilinTemp[1].x != k16S_NULL)\
        {\
        kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_LIN(OBJ, &bilinTemp[0], &bilinTemp[1], (Y), (OBJ)->dispYShift, (OBJ)->dispYRound, (OUT));\
        }\
        else\
    {\
        (OUT)->x = (OUT)->y = (OUT)->z = k16S_NULL;\
    }\
} while(0);\

#define kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_TRILIN(OBJ, P000, P001, P010, P011, P100, P101, P110, P111, X, Y, D, OUT)\
do\
{\
    kPoint3d16s trilinTemp[2];\
    kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_BILIN(OBJ, (P000),(P001), (P010), (P011), (X), (Y), &trilinTemp[0]);\
    kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_BILIN(OBJ, (P100),(P101), (P110), (P111), (X), (Y), &trilinTemp[1]);\
    if(trilinTemp[0].x != k16S_NULL && trilinTemp[1].x != k16S_NULL)\
    {\
        kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_LIN(OBJ, &trilinTemp[0], &trilinTemp[1], (D), (OBJ)->dispDShift, (OBJ)->dispDRound, (OUT));\
    }\
    else\
    {\
        (OUT)->x = (OUT)->y = (OUT)->z = k16S_NULL;\
    }\
} while(0);\

#define kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_LIN(OBJ, P0, P1, FRACT, SHIFT, ROUND, OUT)\
do\
{\
    if((P0)->x != k16S_NULL && (P1)->x != k16S_NULL)\
    {\
        (OUT)->x = (k16s)kxS3D_STEREO_PROFILER_DEP_INTERP((P0)->x, (P1)->x, (FRACT), (SHIFT), (ROUND));\
        (OUT)->y = (k16s)kxS3D_STEREO_PROFILER_DEP_INTERP((P0)->y, (P1)->y, (FRACT), (SHIFT), (ROUND));\
        (OUT)->z = (k16s)kxS3D_STEREO_PROFILER_DEP_INTERP((P0)->z, (P1)->z, (FRACT), (SHIFT), (ROUND));\
    }\
    else\
    {\
        (OUT)->x = (OUT)->y = (OUT)->z = k16S_NULL;\
    }\
}\
while(0);\

#define kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_BILIN(OBJ, P00, P01, P10, P11, X, Y, OUT)\
do\
{\
    kPoint3d16s bilinTemp[2];\
    kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_LIN(OBJ, (P00), (P01), (X), (OBJ)->phaseXShift, (OBJ)->phaseXRound, &bilinTemp[0]);\
    kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_LIN(OBJ, (P10), (P11), (X), (OBJ)->phaseXShift, (OBJ)->phaseXRound, &bilinTemp[1]);\
    if(bilinTemp[0].x != k16S_NULL && bilinTemp[1].x != k16S_NULL)\
    {\
        kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_LIN(OBJ, &bilinTemp[0], &bilinTemp[1], (Y), (OBJ)->phaseYShift, (OBJ)->phaseYRound, (OUT));\
    }\
    else\
    {\
        (OUT)->x = (OUT)->y = (OUT)->z = k16S_NULL;\
    }\
} while(0);\

#define kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_TRILIN(OBJ, P000, P001, P010, P011, P100, P101, P110, P111, X, Y, P, OUT)\
do\
{\
    kPoint3d16s trilinTemp[2];\
    kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_BILIN(OBJ, (P000),(P001), (P010), (P011), (X), (Y), &trilinTemp[0]);\
    kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_BILIN(OBJ, (P100),(P101), (P110), (P111), (X), (Y), &trilinTemp[1]);\
    if(trilinTemp[0].x != k16S_NULL && trilinTemp[1].x != k16S_NULL)\
    {\
        kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_LIN(OBJ, &trilinTemp[0], &trilinTemp[1], (P), (OBJ)->phasePShift, (OBJ)->phasePRound, (OUT));\
    }\
    else\
    {\
        (OUT)->x = (OUT)->y = (OUT)->z = k16S_NULL;\
    }\
} while(0);\


#define kxS3D_STEREO_PROFILER_DEP_LOOKUP_PHASE(PROFILER, VIEWINDEX, XPROJ, YPROJ, PHASE, RESULT)\
do\
{\
    kS3dStereoProfilerDepClass* OBJ = kS3D_STEREO_PROFILER(PROFILER);\
    if((XPROJ) != k16S_NULL && (YPROJ) != k16S_NULL)\
    {\
        k32s dStep = (OBJ)->phaseHeight*(OBJ)->phaseWidth;\
        k32s rStep = (OBJ)->phaseWidth;\
        k32s rcStep = rStep + 1;\
        k32s x = (XPROJ) - (OBJ)->phaseXBegin;\
        k32s y = (YPROJ) - (OBJ)->phaseYBegin;\
        k32s pIndex = ((PHASE) - (OBJ)->phasePBegin) >> (OBJ)->phasePShift;\
        k32s pFract = ((PHASE) - (OBJ)->phasePBegin) & (OBJ)->phasePMask;\
        k32s xIndex = x >> (OBJ)->phaseXShift;\
        k32s yIndex = y >> (OBJ)->phaseYShift;\
        k32s xFract = x & (OBJ)->phaseXMask;\
        k32s yFract = y & (OBJ)->phaseYMask;\
        kPoint3d16s* basePtD0, * basePtD1;\
        if(xIndex >= 0 && xIndex < ((OBJ)->phaseWidth - 1) && yIndex >= 0 && yIndex < ((OBJ)->phaseHeight - 1) && pIndex >= 0 && (pIndex < ((OBJ)->phaseDepth - 1)))\
        {\
            basePtD0 = (kPoint3d16s*) kArray3_At((OBJ)->phaseLut[VIEWINDEX], pIndex, yIndex, xIndex);\
            basePtD1 = basePtD0 + dStep;\
            kxS3D_STEREO_PROFILER_DEP_INTERP_PHASE_TRILIN((OBJ), basePtD0, basePtD0 + 1, basePtD0 + rStep, basePtD0 + rcStep, \
                                                 basePtD1, basePtD1 + 1, basePtD1 + rStep, basePtD1 + rcStep,\
                                                 xFract, yFract, pFract, (RESULT));\
        }\
        else\
        {\
            (RESULT)->x = (RESULT)->y = (RESULT)->z = k16S_NULL;\
        }\
    }\
    else\
    {\
        (RESULT)->x = (RESULT)->y = (RESULT)->z = k16S_NULL;\
    }\
} while(0);\

#define kxS3D_STEREO_PROFILER_DEP_LOOKUP_DISPARITY(PROFILER, XPROJ0, XPROJ1, YPROJ, RESULT)\
do\
{\
    kS3dStereoProfilerDepClass* OBJ = kS3D_STEREO_PROFILER(PROFILER);\
    k32s x, y, d;\
    k32s xIndex, yIndex, dIndex, xFract, yFract, dFract;\
    k32s dStep = (OBJ)->dispHeight*(OBJ)->dispWidth;\
    k32s rStep = (OBJ)->dispWidth; \
    k32s rcStep = rStep + 1;\
    kPoint3d16s* basePtD0, *basePtD1;\
    if ((XPROJ0) != k16S_NULL && (XPROJ1) != k16S_NULL && (YPROJ) != k16S_NULL)\
    {\
        x = (XPROJ0)-(OBJ)->dispXBegin; \
        y = (YPROJ)-(OBJ)->dispYBegin; \
        d = ((XPROJ1)-(k32s)(XPROJ0)) - (OBJ)->dispDBegin; \
        xIndex = x >> (OBJ)->dispXShift;\
        yIndex = y >> (OBJ)->dispYShift;\
        dIndex = d >> (OBJ)->dispDShift;\
        xFract = x & (OBJ)->dispXMask; \
        yFract = y & (OBJ)->dispYMask; \
        dFract = d & (OBJ)->dispDMask; \
        if (xIndex >= 0 && xIndex < ((OBJ)->dispWidth - 1) && yIndex >= 0 && yIndex < ((OBJ)->dispHeight - 1) && dIndex >= 0 && (dIndex < ((OBJ)->dispDepth - 1)))\
        {\
            basePtD0 = (kPoint3d16s*) kArray3_At((OBJ)->disparityLut, dIndex, yIndex, xIndex);\
            basePtD1 = basePtD0 + dStep;\
            kxS3D_STEREO_PROFILER_DEP_INTERP_DISP_TRILIN((OBJ), basePtD0, basePtD0 + 1, basePtD0 + rStep, basePtD0 + rcStep,\
                basePtD1, basePtD1 + 1, basePtD1 + rStep, basePtD1 + rcStep,\
                xFract, yFract, dFract, (RESULT));\
        }\
        else\
        {\
            (RESULT)->x = (RESULT)->y = (RESULT)->z = k16S_NULL;\
        }\
    }\
    else\
    {\
        (RESULT)->x = (RESULT)->y = (RESULT)->z = k16S_NULL;\
    }\
} while(0);\

#define kxS3D_STEREO_PROFILER_DEP_RECTIFY(PROFILER, VIEWINDEX, X, Y, XPROJ, YPROJ)\
do\
{\
    kS3dStereoProfilerDepClass* OBJ = kS3D_STEREO_PROFILER(PROFILER);\
    k32s xIndex,yIndex,xFract,yFract;\
    k32s rStep = (OBJ)->projWidth;\
    k32s rcStep = rStep + 1;\
    kPoint16s* basePt;\
    kPoint16s out;\
    k32s xv = ((X) << (OBJ)->spotXShift) + ((OBJ)->spotOffset[VIEWINDEX].x << kSPOT_CENTRE_SHIFT);\
    k32s yv = ((Y) << (OBJ)->spotYShift) + ((OBJ)->spotOffset[VIEWINDEX].y << kSPOT_CENTRE_SHIFT);\
    if(xv < (OBJ)->projXMax && yv < (OBJ)->projYMax)\
    {\
        xIndex = xv >> OBJ->projXShift;\
        yIndex = yv >> OBJ->projYShift;\
        xFract = xv & OBJ->projXMask;\
        yFract = yv & OBJ->projYMask;\
        basePt = (kPoint16s*) kArray2_At(OBJ->projLut[VIEWINDEX], yIndex, xIndex);\
        kxS3D_STEREO_PROFILER_DEP_INTERP_PROJ_BILIN((OBJ), basePt, basePt + 1, basePt + rStep, basePt + rcStep, xFract, yFract, &out);\
        *(XPROJ) = out.x;\
        *(YPROJ) = out.y;\
    }\
    else\
    {\
        *(XPROJ) = *(YPROJ) = k16S_NULL;\
    }\
} while(0);\


#define kxS3D_STEREO_PROFILER_DEP_RECTIFY_LIN(PROFILER, VIEWINDEX, X, Y, XPROJ, YPROJ)\
do\
{\
    kS3dStereoProfilerDepClass* OBJ = kS3D_STEREO_PROFILER(PROFILER);\
    k32s xIndex,yIndex,xFract;\
    kPoint16s* basePt;\
    kPoint16s out;\
    k32s xv = ((X) << (OBJ)->spotXShift) + ((OBJ)->spotOffset[VIEWINDEX].x << kSPOT_CENTRE_SHIFT);\
    k32s yv = ((Y) << (OBJ)->spotYShift) + ((OBJ)->spotOffset[VIEWINDEX].y << kSPOT_CENTRE_SHIFT);\
    if(xv < (OBJ)->projXMax && yv < (OBJ)->projYMax)\
        {\
        xIndex = xv >> OBJ->projXShift;\
        yIndex = yv >> OBJ->projYShift;\
        xFract = xv & OBJ->projXMask;\
        basePt = (kPoint16s*)kArray2_At(OBJ->projLut[VIEWINDEX], yIndex, xIndex);\
        kxS3D_STEREO_PROFILER_DEP_INTERP_PROJ_LIN((OBJ), basePt, basePt + 1, xFract, (OBJ)->projXShift, (OBJ)->projXRound, &out);\
        *(XPROJ) = out.x;\
        *(YPROJ) = out.y;\
        }\
        else\
        {\
        *(XPROJ) = *(YPROJ) = k16S_NULL;\
        }\
} while(0);\



//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dStereoProfilerDepPair
{
    kPoint3d16s source;
    kPoint3d16s target;

} kS3dStereoProfilerDepPair;

kDeclareValueEx(kVs, kS3dStereoProfilerDepPair, kValue)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dStereoProfilerDepClass 
{
    kS3dStereoProfilerDepParams params;

    kArray2 projLut[2];
    kArray3 phaseLut[2];

    kArray3 disparityLut;

    kPoint32s spotOffset[2];
    k32s spotXShift;
    k32s spotYShift;

    k64f xResolution;
    k64f yResolution;
    k64f zResolution;
    k64f projectionResolution;

    k32s projWidth;
    k32s projHeight;
    k32s projXStep;
    k32s projYStep;
    k32s projXShift;
    k32s projYShift;
    k32s projXRound;
    k32s projYRound;
    k32s projXMask;
    k32s projYMask;
    k32s projXMax;
    k32s projYMax;

    k32s dispXBegin;
    k32s dispYBegin;
    k32s dispDBegin;
    k32s dispWidth;
    k32s dispHeight;
    k32s dispDepth;
    k32s dispXStep;
    k32u dispYStep;
    k32u dispDStep;
    k32u dispXShift;
    k32u dispYShift;
    k32u dispDShift;
    k32u dispXRound;
    k32u dispYRound;
    k32u dispDRound;
    k32u dispXMask;
    k32u dispYMask;
    k32u dispDMask;

    k32s phaseXBegin;
    k32s phaseYBegin;
    k32s phasePBegin;
    k32s phaseWidth;
    k32s phaseHeight;
    k32s phaseDepth;
    k32s phaseXStep;
    k32u phaseYStep;
    k32u phasePStep;
    k32u phaseXShift;
    k32u phaseYShift;
    k32u phasePShift;
    k32u phaseXRound;
    k32u phaseYRound;
    k32u phasePRound;
    k32u phaseXMask;
    k32u phaseYMask;
    k32u phasePMask;

    // Merging vars //
    kS3dPhaseDeltaDepFunction delta[2];

    kArrayList pointPairs[2];
    kArray2 mono[2];
    k64f monoMergeOutlierTolerance; // average multiplier

    kS3dMonoMergeAlg monoMergeAlg;
    kS3dMonoMergeLocalAlg monoMergeLocalAlg;

    kS3dStripeLookupType lookupType;
    kRect3d64f activeAreaRoi;
    kRect3d64f lutLimits;

    kSize leftViewIndex;
    k64f referenceTemperature;
    kBool correctExpansion;
    k64f temperature;

    // Input/output handles saved for SMP operations

    kVsJobQueue inputJobQueue;
    kSize inputViewIndex;
    kArray1 inputPhaseTable;
    kArray2 inputX0;
    kArray2 inputX1;
    kSSize inputYBegin;
    kSSize inputYStep;
    kArray2 outputRanges;

} kS3dStereoProfilerDepClass;

#define kS3D_STEREO_PROFILER(HANDLE) ((kS3dStereoProfilerDepClass*)(HANDLE))

kStatus kS3dStereoProfilerDep_Create(kS3dStereoProfilerDep* profiler);
kStatus kS3dStereoProfilerDep_Init(kS3dStereoProfilerDep profiler, const kS3dStereoProfilerDepParams* params, kS3dStereoCal cal);
kStatus kS3dStereoProfilerDep_Release(kS3dStereoProfilerDep profiler);

kStatus kS3dStereoProfilerDep_FindLutBounds(kS3dStereoProfilerDep profiler, kArray2 map, k32s step, k32s* begin, k32s* count);
kStatus kS3dStereoProfilerDep_UpdateLut(kS3dStereoProfilerDep profiler, kArray2 map, 
                                     kArray1 x, kArray1 y, kArray1 z, kSSize vBegin, kSSize vStep, kArray3 lut);

kStatus kS3dStereoProfilerDep_SolvePhaseDelta(kS3dStereoProfilerDep profiler, kS3dPhaseDeltaDepFunction* delta);
kStatus kS3dStereoProfilerDep_Invert3x3(kS3dStereoProfilerDep profiler, k64f* input, k64f* output);
kStatus kS3dStereoProfilerDep_CalculateMemoryUsage(kS3dStereoProfilerDep profiler, k64s* usage);

kStatus kS3dStereoProfilerDep_MergeSetup(kS3dStereoProfilerDep profiler, kSize lineCount, kSize lineWidth);
kStatus kS3dStereoProfilerDep_UpdateViewOrientation(kS3dStereoProfilerDep profiler, kArray2 disparityMap, kArray1 disparityToZ);


///@brief Applies thermal expansion correction in-place in 16s ranges buffer
kStatus kL3dStereoProfiler_CorrectExpansion(kS3dStereoProfilerDep profiler, kPoint3d16s* output, kSize count);

///@brief Applies transformation in-place in 16s ranges buffer
kStatus kL3dStereoProfiler_ApplyTransformation(kS3dStereoProfilerDep profiler, kPoint3d16s* output, kSize count);

///@brief Clips pre-transform range data to active area ROI
kStatus kL3dStereoProfiler_ClipRoi(kS3dStereoProfilerDep profiler, kPoint3d16s* output, kSize count);


//////////////////////////////////////////////////////////////////////////
// Private lookup algorithms - Stripe Spots
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dStereoProfilerDep_LookupDisparity(kS3dStereoProfilerDep profiler, kS3dStripeSpot* spots0, kS3dStripeSpot* spots1, kSize count, kPoint3d16s* output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupPhase(kS3dStereoProfilerDep profiler, k32u viewIndex, kS3dStripeSpot* spots, k32u* phase, kSize count, kPoint3d16s* output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupPhaseDifference(kS3dStereoProfilerDep profiler, kS3dStripeSpot* spots0, kS3dStripeSpot* spots1, k32u* phase, kSize count, kPoint3d16s* output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupMergeRigid(kS3dStereoProfilerDep profiler, kArray2 spots0, kArray2 spots1, kArray2 phase, kArray2 output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupMergeQuadratic(kS3dStereoProfilerDep profiler, kArray2 spots0, kArray2 spots1, kArray2 phase, kArray2 output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupMergeLocal(kS3dStereoProfilerDep profiler, kArray2 spots0, kArray2 spots1, kArray2 phase, kArray2 output);


//////////////////////////////////////////////////////////////////////////
// Private lookup algorithms - Rectified X Map
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dStereoProfilerDep_LookupMapDisparity(kS3dStereoProfilerDep profiler, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kVsJobQueue jobQueue, kArray2 output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupMapPhase(kS3dStereoProfilerDep profiler, kSize viewIndex, kSSize yBegin, kSize yStep, kArray2 x, kArray1 phaseTable, kVsJobQueue jobQueue, kArray2 output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupMapMergeQuadratic(kS3dStereoProfilerDep profiler, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kVsJobQueue jobQueue, kArray2 output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupMapMergeLocal(kS3dStereoProfilerDep profiler, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kVsJobQueue jobQueue, kArray2 output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupMapMergeRigid(kS3dStereoProfilerDep profiler, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kVsJobQueue jobQueue, kArray2 output);
kVsFx(kStatus) kS3dStereoProfilerDep_LookupMapPhaseDifference(kS3dStereoProfilerDep profiler, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kArray2 output);

kVsFx(kStatus) kS3dStereoProfilerDep_LookupMapPhaseRows(kS3dStereoProfilerDep profiler, kSize viewIndex, kSSize yBegin, kSize yStep, kArray2 x,
                                                     kArray1 phaseTable, kArray2 output, kSize startRow, kSize rowCount);

kVsFx(kStatus) kS3dStereoProfilerDep_LookupMapDisparityRows(kS3dStereoProfilerDep profiler, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1,
                                                         kArray2 output, kSize startRow, kSize rowCount);

kStatus kCall kS3dStereoProfilerDep_LookupDisparityHandler(kS3dStereoProfilerDep profiler, k64u id);
kStatus kCall kS3dStereoProfilerDep_LookupPhaseHandler(kS3dStereoProfilerDep profiler, k64u id);

//////////////////////////////////////////////////////////////////////////
// Currently used by Factory, but should be reorganized
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dStereoProfilerDep_RectifyCoords(kS3dStereoProfilerDep profiler, k32u viewIndex, k32s x, k32s y, k16s* xProj, k16s* yProj);
kVsFx(kStatus) kS3dStereoProfilerDep_RectificationError(kS3dStereoProfilerDep profiler, kPoint64f* imagePt0, kPoint64f* imagePt1, k64f* rectificationError);

kVsFx(kStatus) kS3dStereoProfilerDep_EvaluateImageDisparity64f(kS3dStereoProfilerDep profiler, kPoint64f* point0, kPoint64f* point1, kPoint3d64f* output);
kVsFx(kStatus) kS3dStereoProfilerDep_EvaluateImagePhase64f(kS3dStereoProfilerDep profiler, k32u viewIndex, kPoint64f* point, k64f phaseIndex, kPoint3d64f* output);

kVsFx(k32s)    kS3dStereoProfilerDep_DisparityMin(kS3dStereoProfilerDep profiler);
kVsFx(k32s)    kS3dStereoProfilerDep_DisparityMax(kS3dStereoProfilerDep profiler);


kStatus kS3dStereoProfilerDep_LutLimits(kS3dStereoProfilerDep profiler, kArray3 lut, kPoint3d16s* xyzMin, kPoint3d16s* xyzMax);
kStatus kS3dStereoProfilerDep_UpdateLimits(kS3dStereoProfilerDep profiler);


#endif /* #ifndef LMITECH_KVISION_S3D_STEREOPROFILER_DEP_X_H_INCLUDED */
