#ifndef LMITECH_KVISION_S3D_STEREOPROFILER_DEP_H_INCLUDED
#define LMITECH_KVISION_S3D_STEREOPROFILER_DEP_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>
#include <kVision/L3d/kL3dTransform3d.h>
#include <kVision/S3d/kS3dStereoCal.h>
#include <kVision/Vs/kVsJobQueue.h>

typedef kPointer kS3dStereoProfilerDep;

typedef struct kS3dStereoProfilerDepParams
{
    kL3dCameraWindow window[2];
    kL3dTransform3d transform;  // No longer needed during initialization. Initialize to identity and remove

    k64f resolution;
    k64f phaseMergeThreshold;   // Unused and should be removed

    //expansion correction parameters
    k64f viewDepth;         //Distance from the FOV midrange to the baseline. Should be negative, mm.
    k64f opticalCentre;     //Distance from the FOV midrange to the optical centre (center ray convergence) Negative is closer to sensor.
    k64f expansionCoeff;    //Expansion coefficient (CTE) of the spine material.

} kS3dStereoProfilerDepParams;

kVsFx(kStatus) kS3dStereoProfilerDep_Construct(kS3dStereoProfilerDep* profiler, const kS3dStereoProfilerDepParams* params, kS3dStereoCal cal);
kVsFx(kStatus) kS3dStereoProfilerDep_Destroy(kS3dStereoProfilerDep profiler);

kVsFx(const kS3dStereoProfilerDepParams*) kS3dStereoProfilerDep_Parameters(kS3dStereoProfilerDep profiler);
k64f kS3dStereoProfilerDep_ProjectionResolution(kS3dStereoProfilerDep profiler);

kVsFx(kStatus) kS3dStereoProfilerDep_Lookup(kS3dStereoProfilerDep profiler, kArray2 spots0, kArray2 spots1, kArray2 phase, kArray2 output);

kVsFx(kStatus) kS3dStereoProfilerDep_LookupMap(kS3dStereoProfilerDep profiler, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kVsJobQueue jobQueue, kArray2 output);

kVsFx(kStatus) kS3dStereoProfilerDep_UpdateWindow(kS3dStereoProfilerDep profiler, const kL3dCameraWindow* window0, const kL3dCameraWindow* window1);

kVsFx(kStatus) kS3dStereoProfilerDep_SetLookupType(kS3dStereoProfilerDep profiler, kS3dStripeLookupType type);
kVsFx(kS3dStripeLookupType) kS3dStereoProfilerDep_LookupType(kS3dStereoProfilerDep profiler);

kVsFx(kStatus) kS3dStereoProfilerDep_SetTransform(kS3dStereoProfilerDep profiler, const kL3dTransform3d* transform);
kVsFx(const kL3dTransform3d*) kS3dStereoProfilerDep_Transform(kS3dStereoProfilerDep profiler);

kVsFx(kStatus) kS3dStereoProfilerDep_SetActiveAreaRoi(kS3dStereoProfilerDep profiler, const kRect3d64f* roi);
kVsFx(const kRect3d64f*) kS3dStereoProfilerDep_ActiveAreaRoi(kS3dStereoProfilerDep profiler);

kVsFx(k64f) kS3dStereoProfilerDep_ReferenceTemperature(kS3dStereoProfilerDep profiler);

kVsFx(k64f) kS3dStereoProfilerDep_Temperature(kS3dStereoProfilerDep profiler);
kVsFx(kStatus) kS3dStereoProfilerDep_SetTemperature(kS3dStereoProfilerDep profiler, k64f temperature);

kVsFx(kBool) kS3dStereoProfilerDep_ExpansionCorrectionEnabled(kS3dStereoProfilerDep profiler);
kVsFx(kStatus) kS3dStereoProfilerDep_EnableExpansionCorrection(kS3dStereoProfilerDep profiler, kBool enabled);

kVsFx(kStatus) kS3dStereoProfilerDep_SetMergeOutlierTolerance(kS3dStereoProfilerDep profiler, k64f tolerance);
kVsFx(k64f) kS3dStereoProfilerDep_MergeOutlierTolerance(kS3dStereoProfilerDep profiler);

/**
* Returns the view index of the sensor stereo pair with lower X coordinate relative to the FOV of the sensor. For current sensor models with symmetric
* camera configuration the function can be used directly to determine how camera indices map to physical positions of the cameras.
*
* The function should be used to determine the direction of the Z axis relative to image column coordinates. Assuming standard individual camera
* orientation (Columns increasing with increasing X. No other orientation is supported), foreground points appear left of the background on the
* 'left' camera and right of the background on the 'right' camera. Existing correspondence methodology (kS3dStripeProcessor_ProcessPhaseMap) uses
* this information to eliminate duplicate correspondences
*
* @public              @memberof kS3dStereoProfilerDep
* @param   profiler    Profiler object
* @return              Returns the view index of the stereo pair with the lower X coordinate relative to the field of view of the sensor.
*/
kVsFx(kSize)    kS3dStereoProfilerDep_LeftViewIndex(kS3dStereoProfilerDep profiler);

/**
* Returns total pre-transformation range volume of the constructed lookup tables. Output is a 3D rectangle with mm as units. Can be taken advantage of by
* processing algorithms which set their parameters based on a percentage of the total operating volume.
*
* @public              @memberof kS3dStereoProfilerDep
* @param   profiler    Profiler object
* @return              Total pre-transformation range volume of the constructed lookup tables
*/
kVsFx(const kRect3d64f*) kS3dStereoProfilerDep_CalibrationVolume(kS3dStereoProfilerDep profiler);

kVsFx(kSize)    kS3dStereoProfilerDep_MemoryUsage(kS3dStereoProfilerDep profiler);

///@brief Rectifies fractional image coordinates. Both coordinates must be scaled to kSPOT_CENTRE_SCALE
#define kS3D_STEREO_PROFILER_DEP_RECTIFY(PROFILER, VIEWINDEX, X, Y, XPROJ, YPROJ)               kxS3D_STEREO_PROFILER_DEP_RECTIFY(PROFILER, VIEWINDEX, X, Y, XPROJ, YPROJ)

///@brief Rectifies fractional image coordinates. Both coordinates must be scaled to kSPOT_CENTRE_SCALE, however, Y values must fall on integer rows. 
///No interpolation across rows is performed
#define kS3D_STEREO_PROFILER_DEP_RECTIFY_LIN(PROFILER, VIEWINDEX, X, Y, XPROJ, YPROJ)           kxS3D_STEREO_PROFILER_DEP_RECTIFY_LIN(PROFILER, VIEWINDEX, X, Y, XPROJ, YPROJ)

#define kS3D_STEREO_PROFILER_DEP_LOOKUP_PHASE(PROFILER, VIEWINDEX, XPROJ, YPROJ, PHASE, RESULT) kxS3D_STEREO_PROFILER_DEP_LOOKUP_PHASE(PROFILER, VIEWINDEX, XPROJ, YPROJ, PHASE, RESULT)
#define kS3D_STEREO_PROFILER_DEP_LOOKUP_DISPARITY(PROFILER, XPROJ0, XPROJ1, YPROJ, RESULT)      kxS3D_STEREO_PROFILER_DEP_LOOKUP_DISPARITY(PROFILER, XPROJ0, XPROJ1, YPROJ, RESULT)

#include <kVision/S3d/kS3dStereoProfilerDep.x.h>

#endif /* #define LMITECH_KVISION_S3D_STEREOPROFILER_DEP_H_INCLUDED */
