/**
* @file    kS3dRangeFilter.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef kS3D_RANGE_FILTER_X_H
#define kS3D_RANGE_FILTER_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kS3D_RANGE_FILTER_DEFAULT_MIN_RUN               (8)
#define kS3D_RANGE_FILTER_DEFAULT_RUN_STEP_THRESHOLD    (64000 / 100)   // 1% of the full bit depth. 

typedef struct kS3dRangeFilterClass
{
    kObjectClass base;

    // Algorithm parameters
    kSize mapWidth;
    kSize mapHeight;
    kSize minRunLength;
    kSize runStepThreshold;

    kVsJobQueue jobQueue;

    kArray2 inputMap;

} kS3dRangeFilterClass;

kDeclareClassEx(kVs, kS3dRangeFilter, kObject)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kS3dRangeFilter_VInitClone(kS3dRangeFilter filter, kS3dRangeFilter source, kAlloc allocator);
kVsFx(kStatus) kS3dRangeFilter_VRelease(kS3dRangeFilter filter);
kVsFx(kSize)   kS3dRangeFilter_VSize(kS3dRangeFilter filter);

//non-exported (private) methods
kStatus kS3dRangeFilter_Init(kS3dRangeFilter filter, kAlloc allocator);

kVsFx(kStatus) kS3dRangeFilter_RemoveOutlierRows(kS3dRangeFilter filter, kArray2 map, kSize startRow, kSize rowCount);
kStatus kCall kS3dRangeFilter_RemoveOutlierHandler(kS3dRangeFilter filter, k64u id);


//semi-private methods (API can change any time)
kVsFx(kStatus) kS3dRangeFilter_SetJobQueue(kS3dRangeFilter filter, kVsJobQueue queue);


//cast macro

#endif  /* #ifndef kS3D_RANGE_FILTER_X_H */
