/**
* @file    kS3dPolynomial.x.h
* @brief   Declares the kS3dPolynomial class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_S3D_POLYN2D_X_H
#define KVISION_S3D_POLYN2D_X_H

typedef struct kS3dPolynomialClass
{
    kObjectClass base;
    k64f coeffs[kS3DPOLYNOMIAL8_COUNT];
    k16s order;
}kS3dPolynomialClass;

kDeclareClassEx(kVs, kS3dPolynomial, kObject)

kStatus kS3dPolynomial_Init(kS3dPolynomial polynomial, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dPolynomial_VRelease(kS3dPolynomial polynomial);

k64f kS3dPolynomial_Value2(k64f* pPara, k64f x, k64f y);
k64f kS3dPolynomial_Value3(k64f* pPara, k64f x, k64f y);
k64f kS3dPolynomial_Value4(k64f* pPara, k64f x, k64f y);
k64f kS3dPolynomial_Value5(k64f* pPara, k64f x, k64f y);
k64f kS3dPolynomial_Value6(k64f* pPara, k64f x, k64f y);
k64f kS3dPolynomial_Value7(k64f* pPara, k64f x, k64f y);
k64f kS3dPolynomial_Value8(k64f* pPara, k64f x, k64f y);

#define kS3DPOLYNOMIAL(HANDLE)           ((kS3dPolynomialClass*)(HANDLE))
        

#endif /* #ifndef KVISION_S3D_POLYN2D_X_H */
