#ifndef kS3D_PHASE_SEGMENT_X_H
#define kS3D_PHASE_SEGMENT_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kS3D_PHASE_SEGMENT_DEFAULT_THRESHOLD 10000
#define kS3D_PHASE_SEGMENT_DEFAULT_REPEAT 2

typedef struct kS3dPhaseSegmentClass
{
    kObjectClass base;
    kArray2 map;
    kArray2 data;
    kVsJobQueue jobQueue;
    k32s threshold;
    k32s repeat;
    k32s imageSizeX;
    k32s imageSizeY;

    k32s camIndex;
} kS3dPhaseSegmentClass;

kDeclareClassEx(kVs, kS3dPhaseSegment, kObject)

kVsFx(kStatus) kS3dPhaseSegment_VInitClone(kS3dPhaseSegment segment, kS3dPhaseSegment source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseSegment_VRelease(kS3dPhaseSegment segment);
kVsFx(kSize)   kS3dPhaseSegment_VSize(kS3dPhaseSegment segment);

kStatus kS3dPhaseSegment_Init(kS3dPhaseSegment segment, kType classType, kAlloc alloc);

kStatus kS3dPhaseSegment_FillTopLeft(kS3dPhaseSegment segment);
kStatus kCall kS3dPhaseSegment_FillTopLeftHandler(kS3dPhaseSegment segment, k64u id);
kStatus kS3dPhaseSegment_FillTopLeftThread(kS3dPhaseSegment segment, kSize startRow, kSize rowCount);

kStatus kS3dPhaseSegment_FillBottomRight(kS3dPhaseSegment segment);
kStatus kCall kS3dPhaseSegment_FillBottomRightHandler(kS3dPhaseSegment segment, k64u id);
kStatus kS3dPhaseSegment_FillBottomRightThread(kS3dPhaseSegment segment, kSize startRow, kSize rowCount);

kStatus kS3dPhaseSegment_FillBottomLeft(kS3dPhaseSegment segment);
kStatus kCall kS3dPhaseSegment_FillBottomLeftHandler(kS3dPhaseSegment segment, k64u id);
kStatus kS3dPhaseSegment_FillBottomLeftThread(kS3dPhaseSegment segment, kSize startRow, kSize rowCount);

kStatus kS3dPhaseSegment_FillTopRight(kS3dPhaseSegment segment);
kStatus kCall kS3dPhaseSegment_FillTopRightHandler(kS3dPhaseSegment segment, k64u id);
kStatus kS3dPhaseSegment_FillTopRightThread(kS3dPhaseSegment segment, kSize startRow, kSize rowCount);

kStatus kS3dPhaseSegment_SetJobQueue(kS3dPhaseSegment segment, kVsJobQueue queue);

#endif
