#ifndef kS3D_PHASEOUTLIER_X_H
#define kS3D_PHASEOUTLIER_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kS3D_SEGMENT_OUTLIER_LIMIT_FACTOR  3

typedef struct kS3dPhaseOutlierClass
{
    kObjectClass base;
    kArray2 back;
    kArray2 temp;
    kArray2 data;
    kArray2 valid;
    kVsJobQueue jobQueue;
    k32s imageSizeX;
    k32s imageSizeY;
    k64s sum;
    k32s count;
    k32s tol;
} kS3dPhaseOutlierClass;

kDeclareClassEx(kVs, kS3dPhaseOutlier, kObject)

kVsFx(kStatus) kS3dPhaseOutlier_VInitClone(kS3dPhaseOutlier outlier, kS3dPhaseOutlier source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseOutlier_VRelease(kS3dPhaseOutlier outlier);
kVsFx(kSize)   kS3dPhaseOutlier_VSize(kS3dPhaseOutlier outlier);

kStatus kS3dPhaseOutlier_Init(kS3dPhaseOutlier outlier, kType classType, kAlloc alloc);

kStatus kS3dPhaseOutlier_Deviation(kS3dPhaseOutlier outlier);

kStatus kS3dPhaseOutlier_Row(kS3dPhaseOutlier outlier);
kStatus kCall kS3dPhaseOutlier_RowHandler(kS3dPhaseOutlier outlier, k64u id);
kStatus kS3dPhaseOutlier_RowThread(kS3dPhaseOutlier outlier, kSize startRow, kSize rowCount);

kStatus kS3dPhaseOutlier_Column(kS3dPhaseOutlier outlier);
kStatus kCall kS3dPhaseOutlier_ColumnHandler(kS3dPhaseOutlier outlier, k64u id);
kStatus kS3dPhaseOutlier_ColumnThread(kS3dPhaseOutlier outlier, kSize startRow, kSize rowCount);

kStatus kS3dPhaseOutlier_Area(kS3dPhaseOutlier outlier);
kStatus kCall kS3dPhaseOutlier_AreaHandler(kS3dPhaseOutlier outlier, k64u id);
kStatus kS3dPhaseOutlier_AreaThread(kS3dPhaseOutlier outlier, kSize startRow, kSize rowCount);

kStatus kS3dPhaseOutlier_SetJobQueue(kS3dPhaseOutlier outlier, kVsJobQueue queue);

#endif
