/** 
 * @file    kS3dPhaseAction.h
 * @brief   Declares the kS3dPhaseAction class. 
 * 
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef kS3D_PHASE_ACTION_H
#define kS3D_PHASE_ACTION_H


#include <kVision/Common/kVision.h>
#include <kFireSync/Action/kAxAction.h>

/**
 * @class   kS3dPhaseAction
 * @ingroup kVision
 * @brief   This is the action that adds phase decode extension to the cameras of the sensor, sets up decoder parameters and projector pattern
 *          please note that every time the action is invoked it will configure the projection and decoding settings. Settings that are not specific to phase decode and
 *          stripe pattern need to be manually reset (e.g. camera exposure, output mode)
 */
typedef kAxAction kS3dPhaseAction; 

#include <kVision/S3d/kS3dPhaseAction.x.h>

#endif
