/**
* @file    kS3dGrayCodeMedian.h
* @brief   Declares the kS3dGrayCodeMedian class. 
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef kS3D_GRAYCODE_MEDIAN_H
#define kS3D_GRAYCODE_MEDIAN_H

#include <kVision/S3d/kS3dPhaseCombiner.h>
#include <kVision/S3d/kS3dVolumeCheckUtilities.h>

/**
* @class       kS3dGrayCodeMedian
* @extends     kObject
* @ingroup     kVision-M3d
* @brief       Class for the internal data processing during a measurement..
*/
typedef kObject kS3dGrayCodeMedian;

/**
* Constructs a kS3dGrayCodeMedian object
*
* @public              @memberof kS3dGrayCodeMedian
* @param   median       Destination for the constructed object handle.
* @param   params      handle of the median settings.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dGrayCodeMedian_Construct(kS3dGrayCodeMedian* median, kAlloc allocator);

/**
*  
*
* @public              @memberof kS3dGrayCodeMedian
* @param   median        kS3dGrayCodeMedian object.
* @return              Operation status.
*/
kVsFx(kStatus) kS3dGrayCodeMedian_Run(kS3dGrayCodeMedian median, kArray2 data, kArray2 temp);

kVsFx(kStatus) kS3dGrayCodeMedian_SetThreshold(kS3dGrayCodeMedian median, k32s threshold);
kVsFx(k32s) kS3dGrayCodeMedian_Threshold(kS3dGrayCodeMedian median);
kVsFx(kStatus) kS3dGrayCodeMedian_SetRepeat(kS3dGrayCodeMedian median, k32s repeat);

kVsFx(k32s) kS3dGrayCodeMedian_Repeat(kS3dGrayCodeMedian median);

kStatus kS3dGrayCodeMedian_SetJobQueue(kS3dGrayCodeMedian median, kVsJobQueue queue);

#endif
