#ifndef kS3D_ENCODING_MATH_X_H
#define kS3D_ENCODING_MATH_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(k64f) kS3dEncodingMath_PhaseStepsTrim(kSize stepCount)
{    
    const k64f angleShift = 2 * kMATH_PI / stepCount;

    if (stepCount > 3) return 0; // DEB legacy support for now!

    return angleShift / 3.0;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus) kS3dEncodingMath_PhaseSteps(kSize stepCount, k64f trim, k64f* outSteps, kSize capacity)
{
    const k64f angleShift = (2 * kMATH_PI - trim) / stepCount;
    kSize i;

    kCheckArgs(stepCount <= capacity);

    for (i = 0; i < stepCount; ++i)
    {
        outSteps[i] = i * angleShift;// +(trim / 3); // don't start from 0
    }

    return kOK;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus) kS3dEncodingMath_EmbeddedPhasePeriods(const k64f* coefficients, kSize count, k64f* embeddedPeriods, kSize capacity)
{
    k64f mult = 1;
    kSize i;

    kCheckArgs(count <= capacity);

    for (i = 0; i < count; ++i)
    {
        mult *= coefficients[i];

        embeddedPeriods[i] = mult;
    }

    return kOK;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus) kS3dEncodingMath_PatternPhasePeriods(const k64f* embeddedPeriods, kSize count, k64f* patternPeriods, kSize capacity)
{
    kSize i;
    k64f period0, periodN;

    kCheckArgs(count <= capacity);
    kCheckArgs(count > 0);

    period0 = embeddedPeriods[0];

    patternPeriods[0] = period0;

    for (i = 1; i < count; ++i)
    {
        periodN = embeddedPeriods[i];

        patternPeriods[i] = period0 * periodN / (period0 + periodN);
    }

    return kOK;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif /* #ifndef kS3D_ENCODING_MATH_X_H */
