/**
* @file    kS3dBm.h
* @brief   Declares the kS3dBm class.
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KS3D_SPECKLE_MATCH_ALG_BM_H
#define KS3D_SPECKLE_MATCH_ALG_BM_H

#include <kVision/Common/kVision.h>
#include <kVision/S3d/kS3dSpeckleMatchAlg.h>

/**
* @class       kS3dBm
* @extends     kS3dSpeckleMatchAlg
* @ingroup     kVision-S3d
* @brief       Implement a 'winner take all' Block Matching algorithm. The implementation is heavily based on OpenCV BM
*              codebase. 
*/
typedef kS3dSpeckleMatchAlg kS3dBm;

/**
* Constructs a BM algorithm object
*
* @public              @memberof kS3dSpeckleMatchAlg
* @param   alg         Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dBm_Construct(kS3dBm* alg, kAlloc alloc);

#include <kVision/S3d/kS3dBm.x.h>

#endif  /* KS3D_SPECKLE_MATCH_ALG_BM_H */
