#ifndef LMITECH_KVISION_S3D_ACTIVEAREA_H_INCLUDED
#define LMITECH_KVISION_S3D_ACTIVEAREA_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/S3d/kS3dStereoCal.h>

#define kS3D_ACTIVE_AREA_VIEW_COUNT     (2)

typedef struct kS3dActiveAreaResult 
{
    kL3dCameraWindow window[kS3D_ACTIVE_AREA_VIEW_COUNT];    
    k64f phaseBegin;
    k64f phaseSpan;
    k64f ySampleBegin;
    k64f ySampleSpan;
} kS3dActiveAreaResult;

typedef kPointer kS3dActiveArea;

kVsFx(kStatus) kS3dActiveArea_Construct(kS3dActiveArea* area, kS3dStereoCal cal);
kVsFx(kStatus) kS3dActiveArea_Destroy(kS3dActiveArea area);

kVsFx(kStatus) kS3dActiveArea_SetGranularity(kS3dActiveArea area, k32u x, k32u y, k32u width, k32u height);
kVsFx(kStatus) kS3dActiveArea_SetLimits(kS3dActiveArea area, k32u widthMin, k32u widthMax, k32u heightMin, k32u heightMax, k32u xSubsamplingMax, k32u ySubsamplingMax);

//Note: x and y resolutions are in the world space while x and y granularities and subsamplings are in the image space.
kVsFx(kStatus) kS3dActiveArea_Calculate(kS3dActiveArea area, const kRect3d64f* roi, k64f xResolution, k64f yResolution, kS3dActiveAreaResult* result);

#endif /* #define LMITECH_KVISION_S3D_ACTIVEAREA_H_INCLUDED */
