#ifndef LMITECH_KVISION_KP3D_SENSORCAL_H_INCLUDED
#define LMITECH_KVISION_KP3D_SENSORCAL_H_INCLUDED

#include <kFireSync/Data/kDataTree.h>
#include <kFireSync/Client/kNode.h>
#include <kApi/Data/kArray1.h>
#include <kVision/Common/kVision.x.h>

#define kP3D_SENSOR_CAL_FILE_NAME    "Cal.kdat"

typedef kPointer kP3dSensorCal;

kVsFx(kStatus) kP3dSensorCal_Construct(kP3dSensorCal* cal, k32u lutCount);
kVsFx(kStatus) kP3dSensorCal_Load(kP3dSensorCal* cal, kNode node, const kChar* fileName);
kVsFx(kStatus) kP3dSensorCal_Save(kP3dSensorCal cal, kNode node, const kChar* filename);
kVsFx(kStatus) kP3dSensorCal_Destroy(kP3dSensorCal cal);

kVsFx(kStatus) kP3dSensorCal_SetId(kP3dSensorCal cal, k32u id);
kVsFx(kStatus) kP3dSensorCal_SetTimestamp(kP3dSensorCal cal, const kChar* timestamp);
kVsFx(kStatus) kP3dSensorCal_SetLutBegin(kP3dSensorCal cal, k32s lutBegin);
kVsFx(kStatus) kP3dSensorCal_SetLutStep(kP3dSensorCal cal, k32u lutStep);

kVsFx(k32u) kP3dSensorCal_Id(kP3dSensorCal cal);
kVsFx(const kChar*) kP3dSensorCal_Timestamp(kP3dSensorCal cal);
kVsFx(k32s) kP3dSensorCal_LutBegin(kP3dSensorCal cal);
kVsFx(k32u) kP3dSensorCal_LutStep(kP3dSensorCal cal);

kVsFx(kArray1) kP3dSensorCal_Lut(kP3dSensorCal cal);

#endif  /* #ifndef LMITECH_KVISION_KP3D_SENSORCAL_H_INCLUDED */
