#ifndef LMITECH_KVISION_KP3D_PROFILER_H_INCLUDED
#define LMITECH_KVISION_KP3D_PROFILER_H_INCLUDED

#include <kVision/P3d/kP3dSensorCal.h>
#include <kFireSync/Data/kSpot.h>

typedef kPointer kP3dProfiler;

typedef struct kP3dProfilerParams 
{
    k32u windowX;
    k32u windowWidth;
    k32u windowSubsampling;
    k64f fovZ;
    k64f fovDepth;
    k64f resolution;
    kBool clipFov;
} kP3dProfilerParams;

kVsFx(kStatus) kP3dProfiler_Construct(kP3dProfiler* profiler, const kP3dProfilerParams* params, kP3dSensorCal cal);
kVsFx(kStatus) kP3dProfiler_Destroy(kP3dProfiler profiler);

kVsFx(kStatus) kP3dProfiler_LookupSingle(kP3dProfiler profiler, const kSpot* spots, k32u spotCount, k16s* output);

#endif /* #ifndef LMITECH_KVISION_KP3D_PROFILER_H_INCLUDED */
