#ifndef LMITECH_KVISION_MP3D_TRACHEIDBLOCKINFO_H_INCLUDED 
#define LMITECH_KVISION_MP3D_TRACHEIDBLOCKINFO_H_INCLUDED 

#include <kFireSync/kFsDef.h>
#include <kVision/Mp3d/kMp3dCommon.h>
#include <kVision/L3d/kL3dCommon.h>

#define kMP3D_TRACHEID_BLOCK_NAME                     "Tracheid"
#define kMP3D_TRACHEID_BLOCK_TYPE_NAME                "kMp3dTracheidBlock"

#define kMP3D_TRACHEID_BLOCK_INSUMS_NAME              "InSums"
#define kMP3D_TRACHEID_BLOCK_OUTRANGES_NAME           "OutRanges"
#define kMP3D_TRACHEID_BLOCK_OUTMOMENTS_NAME          "OutMoments"
#define kMP3D_TRACHEID_BLOCK_OUTSPOTS_NAME            "OutSpots"
#define kMP3D_TRACHEID_BLOCK_OUTSPOTSPLOT_NAME        "OutSpotsPlot"
#define kMP3D_TRACHEID_BLOCK_OUTRANGEPLOT_NAME        "OutRangePlot"
#define kMP3D_TRACHEID_BLOCK_OUTSCATTER_NAME          "OutScatter"
#define kMP3D_TRACHEID_BLOCK_OUTAREA_NAME             "OutArea"
#define kMP3D_TRACHEID_BLOCK_OUTANGLE_NAME            "OutAngle"
#define kMP3D_TRACHEID_BLOCK_OUTTRACHEIDPLOT_NAME     "OutTracheidPlot"

typedef enum
{
    kMP3D_TRACHEID_BLOCK_INSUMS0            = 0,
    kMP3D_TRACHEID_BLOCK_INSUMS1            = 1,
    kMP3D_TRACHEID_BLOCK_OUTRANGES0         = 2,
    kMP3D_TRACHEID_BLOCK_OUTRANGES1         = 3,
    kMP3D_TRACHEID_BLOCK_OUTMOMENTS0        = 4, 
    kMP3D_TRACHEID_BLOCK_OUTMOMENTS1        = 5,
    kMP3D_TRACHEID_BLOCK_OUTSPOTS0          = 6,
    kMP3D_TRACHEID_BLOCK_OUTSPOTS1          = 7,
    kMP3D_TRACHEID_BLOCK_OUTSPOTSPLOT0      = 8,
    kMP3D_TRACHEID_BLOCK_OUTSPOTSPLOT1      = 9,
    kMP3D_TRACHEID_BLOCK_OUTRANGEPLOT0      = 10,
    kMP3D_TRACHEID_BLOCK_OUTRANGEPLOT1      = 11,
    kMP3D_TRACHEID_BLOCK_OUTSCATTER0        = 12,
    kMP3D_TRACHEID_BLOCK_OUTSCATTER1        = 13,
    kMP3D_TRACHEID_BLOCK_OUTAREA0           = 14,
    kMP3D_TRACHEID_BLOCK_OUTAREA1           = 15,
    kMP3D_TRACHEID_BLOCK_OUTANGLE0          = 16,
    kMP3D_TRACHEID_BLOCK_OUTANGLE1          = 17,
    kMP3D_TRACHEID_BLOCK_OUTTRACHEIDPLOT0 = 18,
    kMP3D_TRACHEID_BLOCK_OUTTRACHEIDPLOT1 = 19
} TracheidBlockPort;

typedef kPointer kMp3dTracheidBlockInfo;

kVsFx(kStatus) kMp3dTracheidBlockInfo_Construct(kMp3dTracheidBlockInfo* info);
kVsFx(kStatus) kMp3dTracheidBlockInfo_Load(kMp3dTracheidBlockInfo* info, kXml xml);
kVsFx(kStatus) kMp3dTracheidBlockInfo_Destroy(kMp3dTracheidBlockInfo info);
kVsFx(kStatus) kMp3dTracheidBlockInfo_Store(kMp3dTracheidBlockInfo info, kXml* xml);

kVsFx(kStatus) kMp3dTracheidBlockInfo_Read(kMp3dTracheidBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kMp3dTracheidBlockInfo_Write(kMp3dTracheidBlockInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kMp3dTracheidBlockInfo_SetCalFileName(kMp3dTracheidBlockInfo info, const kChar* fileName);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetRunWindow(kMp3dTracheidBlockInfo info, const kL3dCameraWindow* window, kSize viewIndex);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetFov(kMp3dTracheidBlockInfo info, const kRect3d64f* fov);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetMaxSpotsPerId(kMp3dTracheidBlockInfo info, k32u maxSpots);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetWeakMultiplesFactor(kMp3dTracheidBlockInfo info, k32s factor);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetIdCorrectionMinSeperation(kMp3dTracheidBlockInfo info, k32u seperation);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetSpotEdgeWindow(kMp3dTracheidBlockInfo info, k32s spotEdgeWindow);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetTracheidThreshold(kMp3dTracheidBlockInfo info, k32u tracheidThreshold);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetBackgroundWidth(kMp3dTracheidBlockInfo info, k32u backgroundWidth);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetSpotThreshold(kMp3dTracheidBlockInfo info, k32u spotThreshold);
kVsFx(kStatus) kMp3dTracheidBlockInfo_SetBatchSize(kMp3dTracheidBlockInfo info, k32u batchSize);

kVsFx(const kChar*) kMp3dTracheidBlockInfo_CalFileName(kMp3dTracheidBlockInfo info);
kVsFx(const kL3dCameraWindow*) kMp3dTracheidBlockInfo_RunWindow(kMp3dTracheidBlockInfo info, kSize viewIndex);
kVsFx(const kRect3d64f*) kMp3dTracheidBlockInfo_Fov(kMp3dTracheidBlockInfo info);
kVsFx(k32u) kMp3dTracheidBlockInfo_MaxSpotsPerId(kMp3dTracheidBlockInfo info);
kVsFx(k32s) kMp3dTracheidBlockInfo_WeakMultiplesFactor(kMp3dTracheidBlockInfo info);
kVsFx(k32u) kMp3dTracheidBlockInfo_IdCorrectionMinSeperation(kMp3dTracheidBlockInfo info);
kVsFx(k32s) kMp3dTracheidBlockInfo_SpotEdgeWindow(kMp3dTracheidBlockInfo info);
kVsFx(k32u) kMp3dTracheidBlockInfo_TracheidThreshold(kMp3dTracheidBlockInfo info);
kVsFx(k32u) kMp3dTracheidBlockInfo_BackgroundWidth(kMp3dTracheidBlockInfo info);
kVsFx(k32u) kMp3dTracheidBlockInfo_SpotThreshold(kMp3dTracheidBlockInfo info);
kVsFx(k32u) kMp3dTracheidBlockInfo_BatchSize(kMp3dTracheidBlockInfo info);

#endif /* #ifndef LMITECH_KVISION_MP3D_TRACHEIDBLOCKINFO_H_INCLUDED   */
