#ifndef LMITECH_KVISION_L3D_TRANSFORM3D_H_INCLUDED
#define LMITECH_KVISION_L3D_TRANSFORM3D_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>

/* 
    3D transformation matrix 

    [ xx xy xz xt ]
    [ yx yy yz yt ]
    [ zx zy zz zt ]
    [ 0  0  0  1  ]
*/

typedef struct kL3dTransform3d 
{
    k64f xx;
    k64f xy;
    k64f xz;
    k64f xt;

    k64f yx;
    k64f yy;
    k64f yz;
    k64f yt;

    k64f zx;
    k64f zy;
    k64f zz;
    k64f zt;

} kL3dTransform3d;

kVsFx(kStatus) kL3dTransform3d_Write(const kL3dTransform3d* transform, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dTransform3d_Read(kL3dTransform3d* transform, kXml xml, kXmlItem item);

kVsFx(kStatus) kL3dTransform3d_Identity(kL3dTransform3d* transform);

kVsFx(kStatus) kL3dTransform3d_Translate(const kL3dTransform3d* transform, k64f x, k64f y, k64f z, kL3dTransform3d* result);
kVsFx(kStatus) kL3dTransform3d_Rotate(const kL3dTransform3d* transform, k64f ax, k64f ay, k64f az, k64f degrees, kL3dTransform3d* result);
kVsFx(kStatus) kL3dTransform3d_Scale(const kL3dTransform3d* transform, k64f x, k64f y, k64f z, kL3dTransform3d* result);

kVsFx(kStatus) kL3dTransform3d_Mul(const kL3dTransform3d* right, const kL3dTransform3d* left, kL3dTransform3d* result);
kVsFx(kStatus) kL3dTransform3d_InvertOrtho(const kL3dTransform3d* transform, kL3dTransform3d* result);
kVsFx(kStatus) kL3dTransform3d_Apply(const kL3dTransform3d* transform, k64f x, k64f y, k64f z, k64f* xOut, k64f* yOut, k64f* zOut);
kVsFx(kStatus) kL3dTransform3d_ApplyN(const kL3dTransform3d* transform, const k64f* x, const k64f* y, const k64f* z, k32u count, k64f* xOut, k64f* yOut, k64f* zOut);
kVsFx(kStatus) kL3dTransform3d_ApplyNPoint3d16s(const kL3dTransform3d* transform, k64f xRes, k64f yRes, k64f zRes, const kPoint3d16s* points, k32u count, kPoint3d16s* pointsOut);
kVsFx(kStatus) kL3dTransform3d_ApplyNPoint3d64f(const kL3dTransform3d* transform, const kPoint3d64f* points, k32u count, kPoint3d64f* pointsOut);

#endif /* #define LMITECH_KVISION_L3D_TRANSFORM3D_H_INCLUDED */
