#ifndef LMITECH_KVISION_L3D_SEGMENT_SORT_BLOCK_X_H_INCLUDED
#define LMITECH_KVISION_L3D_SEGMENT_SORT_BLOCK_X_H_INCLUDED

#include <kVision/L3d/kL3dSegmentSortBlockInfo.h>
#include <kVision/L3d/kL3dSegmentSortBlock.h>
#include <kVision/L3d/kL3dSegmentSorter.h>
#include <kFireSync/Data/kMsg.h>
#include <kFireSync/Pipe/kPxPort.h>

#define kL3D_SEGMENT_SORT_BLOCK_DESCRIPTION                 "Segments and filters list of spots (kSpot, kFpgaSpot, kFpgaSpotWide) by continuity"
#define kL3D_SEGMENT_SORT_BLOCK_DEFAULT_SEGMENT_CAPACITY    (1500)
#define kL3D_SEGMENT_SORT_BLOCK_DEFAULT_CENTRE_MARGIN       (16)
#define kL3D_SEGMENT_SORT_BLOCK_DEFAULT_SLICE_MARGIN        (16)
#define kL3D_SEGMENT_SORT_BLOCK_DEFAULT_MIN_LENGTH          (5)
#define kL3D_SEGMENT_SORT_BLOCK_DEFAULT_OVERLAP_THRESHOLD   (0)
#define kL3D_SEGMENT_SORT_BLOCK_DEFAULT_CENTRE_RANGE        (640)

typedef struct kL3dSegmentSortBlockClass
{
    kPxBlockClass base;

    kL3dSegmentSortBlockInfo settings;
    kL3dSegmentSorter sorter;

    kArrayList segmentSpots;

} kL3dSegmentSortBlockClass;

kDeclareClassEx(kVs, kL3dSegmentSortBlock, kPxBlock)

kVsFx(const kChar*) kL3dSegmentSortBlock_VDescription();
kVsFx(kStatus) kL3dSegmentSortBlock_VOnSetup(kL3dSegmentSortBlock block);
kVsFx(kStatus) kL3dSegmentSortBlock_VOnStart(kL3dSegmentSortBlock block);
kVsFx(kStatus) kL3dSegmentSortBlock_VOnReceive(kL3dSegmentSortBlock block, kPxPort port, kMsgSet msg);
kVsFx(kStatus) kL3dSegmentSortBlock_VOnStop(kL3dSegmentSortBlock block);

kVsFx(kStatus) kL3dSegmentSortBlock_ValidateInfo(kL3dSegmentSortBlock block, kL3dSegmentSortBlockInfo info);
kVsFx(kStatus) kL3dSegmentSortBlock_DefaultInfo(kL3dSegmentSortBlock block, kL3dSegmentSortBlockInfo info);

#endif /* #ifndef LMITECH_KVISION_L3D_SEGMENT_SORT_BLOCK_X_H_INCLUDED */
