#ifndef LMITECH_KVISION_L3D_RANGELINESAMPLER_H_INCLUDED
#define LMITECH_KVISION_L3D_RANGELINESAMPLER_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>

typedef kPointer kL3dRangeLineSampler;

typedef struct kL3dRangeLineSamplerParams 
{
    k32u viewCount;
    k32u lineCount;
    k32u profileChannels;

    kBool outputSteps;

    k16s xStart;
    k16s xStep;
    k32u xCount;
    k16s xStepThreshold;

    k16s zMin;
    k16s zMax;

    k32u mergeType;
    k16s mergeThreshold;

} kL3dRangeLineSamplerParams;

kVsFx(kStatus) kL3dRangeLineSampler_Construct(kL3dRangeLineSampler * sampler, const kL3dRangeLineSamplerParams* params);
kVsFx(kStatus) kL3dRangeLineSampler_Destroy(kL3dRangeLineSampler sampler);

kVsFx(const kL3dRangeLineSamplerParams*) kL3dRangeLineSampler_Params(kL3dRangeLineSampler sampler);
kVsFx(const kRect32s*) kL3dRangeLineSampler_ViewFov(kL3dRangeLineSampler sampler, k32u viewIndex);

kVsFx(kStatus) kL3dRangeLineSampler_SetViewFov(kL3dRangeLineSampler sampler, k32u viewIndex, const kRect32s* fov);
kVsFx(kStatus) kL3dRangeLineSampler_SetPrimaryView(kL3dRangeLineSampler sampler, k32u lineIndex, k32u viewIndex);
kVsFx(kStatus) kL3dRangeLineSampler_SetSecondaryView(kL3dRangeLineSampler sampler, k32u lineIndex, k32u viewIndex);

kVsFx(kStatus) kL3dRangeLineSampler_ResampleViewData(kL3dRangeLineSampler sampler, k32u lineIndex, k32u viewIndex, k16s* profile, k32u count, k16s* result);

kVsFx(kStatus) kL3dRangeLineSampler_Update(kL3dRangeLineSampler sampler, k32u lineIndex, k32u viewIndex, k16s* profile, k32u count);
kVsFx(kStatus) kL3dRangeLineSampler_Result(kL3dRangeLineSampler sampler, k32u lineIndex, k16s* profile);

#endif /* #ifndef LMITECH_KVISION_L3D_RANGELINESAMPLER_H_INCLUDED */
