/**
* @file    kL3dLvdsImageErrorsBlockInfo.h
* @brief   Declares the kL3dLvdsImageErrorsBlockInfo class.
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
*/
#ifndef L3D_LVDS_IMAGE_ERRORS_BLOCK_INFO_H_INCLUDED
#define L3D_LVDS_IMAGE_ERRORS_BLOCK_INFO_H_INCLUDED

#include <kVision/Common/kVision.h>

/**
* @class   kL3dLvdsImageErrorsBlockInfo
* @ingroup kVision
* @brief   Settings class for kL3dLvdsImageErrorsBlockInfo
*/
typedef kObject kL3dLvdsImageErrorsBlockInfo;

/**
* Constructs the kL3dLvdsImageErrorsBlockInfo object.  You do not need to call this directly when loading a pre-existing xml as kL3dLvdsImageErrorsBlockInfo_Load will call this for you.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object
* @param   allocator    The allocator to use for constructing the class.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_Construct(kL3dLvdsImageErrorsBlockInfo *info, kAlloc allocator);


/**
* Creates a kL3dLvdsImageErrorsBlockInfo object and loads the xml settings into the class.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object
* @param   xml          The xml settings for the block.
* @param   allocator    The allocator to use for constructing the class.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_Load(kL3dLvdsImageErrorsBlockInfo* info, kXml xml, kAlloc allocator);

/**
* Saves the kL3dLvdsImageErrorsBlockInfo object into an xml so that it can be used by the block.
* This function will allocate a new kXml object and return it to the user.  Ownership of this object is transferred to the user.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object
* @param   xml          The xml settings for the block (output).
* @param   alloc        The allocator to use for constructing the class.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_Save(kL3dLvdsImageErrorsBlockInfo info, kXml* xml, kAlloc alloc);

/**
* Validates the parameters of the block.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object
* @return               Operation status.
*/
kStatus kL3dLvdsImageErrorsBlockInfo_Validate(kL3dLvdsImageErrorsBlockInfo info);

/**
* Resets the paraemters to the default parameters.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object
* @return               Operation status.
*/
kStatus kL3dLvdsImageErrorsBlockInfo_Clear(kL3dLvdsImageErrorsBlockInfo info);

/**
* Gets the noise tolerance.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object.
* @return               The noise tolerance.
*/
kVsFx(kSize) kL3dLvdsImageErrorsBlockInfo_NoiseTolerance(kL3dLvdsImageErrorsBlockInfo info);

/**
* Sets the noise tolerance.  Any pixel intensity change less than this value will be considered background noise.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object.
* @param   noiseTolerance The noise tolerance.  
* @return               Operation status.
*/
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_SetNoiseTolerance(kL3dLvdsImageErrorsBlockInfo info, kSize noiseTolerance);

/**
* Gets the pixel tolerance.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object.
* @return               The pixel tolerance.
*/
kVsFx(kSize) kL3dLvdsImageErrorsBlockInfo_PixelTolerance(kL3dLvdsImageErrorsBlockInfo info);

/**
* Sets the pixel tolerance.  How many pixels need to be different for the image to be considered different.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object.
* @param   pixelTolerance The pixel tolerance.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_SetPixelTolerance(kL3dLvdsImageErrorsBlockInfo info, kSize pixelTolerance);

/**
* Gets the sum tolerance.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object.
* @return               The sum tolerance.
*/
kVsFx(kSize) kL3dLvdsImageErrorsBlockInfo_SumTolerance(kL3dLvdsImageErrorsBlockInfo info);

/**
* Sets the sum tolerance.  The pixel sum is the sum of the intesity differences of all pixels that are considered different.  That is, it does not consider pixels below the noise tolerance.
* The sum tolerance is how large this can be before the image is considered to be different.
*
* @public               @memberof kL3dLvdsImageErrorsBlockInfo
* @param   info         The kL3dLvdsImageErrorsBlockInfo object.
* @param   sumTolerance The sum tolerance.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_SetSumTolerance(kL3dLvdsImageErrorsBlockInfo info, kSize sumTolerance);


#include <kVision/L3d/kL3dLvdsImageErrorsBlockInfo.x.h>

#endif
