/**
* @file    kG3dSegmentPlanes.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_SEGMENT_PLANES_X_H
#define KVISION_kG3D_SEGMENT_PLANES_X_H

typedef struct kG3dSegmentPlanesClass
{
    kObjectClass base;
    kArrayList tracks;
    kPoint3d64f scale;
    kArray2 sumMap;
    kArray2 countMap;

    kArray2 maskMap;
    kArray2 heightmap;
    kArray2 diffMap;
    kArray1 cornerPoints;
    k32s imageSizeX;
    k32s imageSizeY;
    kBool initMaskMap;
    kBool initDiffMap;
    k32s sampleIndex;
    k32s repeatIndex;
    kL3dTransform3d T;
    k32s trackCount;
    k64f maxTol;
    k64f minTol;
    k32s filterWidth;

    k64f zmin;
    k64f zmax;


    k64s outSum[kG3DCONTOURTEMPLATE_TRACK_PLANE_SUM_COUNT];
    k16s outDev;
    k64s outDevSum;
    k32s outDevCount;
    kBool outSuccess;
    kPoint3d64f outPlane;

 //   k16s inBit[kG3DCONTOURTEMPLATE_TRACK_MAX_COUNT];
 //   k16s bandBit[kG3DCONTOURTEMPLATE_TRACK_MAX_COUNT];
 //   k16s outBit[kG3DCONTOURTEMPLATE_TRACK_MAX_COUNT];
} kG3dSegmentPlanesClass;

kDeclareClassEx(kVs, kG3dSegmentPlanes, kObject)

kStatus kG3dSegmentPlanes_Init(kG3dSegmentPlanes planes, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dSegmentPlanes_VInitClone(kG3dSegmentPlanes planes, kG3dSegmentPlanes source, kAlloc allocator);
kVsFx(kSize)   kG3dSegmentPlanes_VSize(kG3dSegmentPlanes planes);
kVsFx(kStatus) kG3dSegmentPlanes_VRelease(kG3dSegmentPlanes planes);

kStatus kG3dSegmentPlanes_Setup(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_CreateMaskMap(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_FitMaskPlanes(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_FillTrackHistogram(kG3dSegmentPlanes planes, kBool dynamic);
kStatus kG3dSegmentPlanes_FillHeightmapGaps(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_CalculateTrackParameter(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_FillMaskPlanesSum(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_Deviation(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_Outlier(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_MedianFilter5(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_CorrectionOutlier(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_UpdataMaskMap(kG3dSegmentPlanes planes);
kStatus kG3dSegmentPlanes_ExportGlueBandHistogram(kG3dSegmentPlanes planes);

#endif  /* KVISION_kG3D_SEGMENT_PLANES_X_H */
