/**
* @file    kG3dPolynomial.x.h
* @brief   Declares the kG3dPolynomial class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_POLYNOMIAL_X_H
#define KVISION_kG3D_POLYNOMIAL_X_H

typedef struct kG3dPolynomialClass
{
    kObjectClass base;
    k64f coeffs[kG3D_POLYNOMIAL8_COUNT];
    k16s order;
}kG3dPolynomialClass;

kDeclareClassEx(kVs, kG3dPolynomial, kObject)

kStatus kG3dPolynomial_Init(kG3dPolynomial polynomial, kType classType, kAlloc alloc);
kVsFx(kStatus) kG3dPolynomial_VRelease(kG3dPolynomial polynomial);

k64f kG3dPolynomial_Value2(k64f* pPara, k64f x, k64f y);
k64f kG3dPolynomial_Value3(k64f* pPara, k64f x, k64f y);
k64f kG3dPolynomial_Value4(k64f* pPara, k64f x, k64f y);
k64f kG3dPolynomial_Value5(k64f* pPara, k64f x, k64f y);
k64f kG3dPolynomial_Value6(k64f* pPara, k64f x, k64f y);
k64f kG3dPolynomial_Value7(k64f* pPara, k64f x, k64f y);
k64f kG3dPolynomial_Value8(k64f* pPara, k64f x, k64f y);
        

#endif /* #ifndef KVISION_kG3D_POLYNOMIAL_X_H */
