/**
* @file    kG3dContourFitLine.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_CONTOURFITLINE_X_H
#define KVISION_kG3D_CONTOURFITLINE_X_H

#define kG3D_CONTOURFITLINE_DEFAULT_COUNT_MINIMUM  400
#define kG3D_CONTOURFITLINE_DEFAULT_MERGE_TOLERANCE  10
#define kG3D_CONTOURFITLINE_DEFAULT_LINE_TOLERANCE  20 
#define kG3D_CONTOURFITLINE_DEFAULT_RECTANGLE_TOLERANCE  10 
#define kG3D_CONTOURFITLINE_BODERPOOFILE_MAX  6 
#define kG3D_CONTOURFITLINE_EDGE_POINTS_MAX  12 

#define kG3D_CONTOURFITLINE_DEFAULT_DIRECTION_COUNT  8 
#define kG3D_CONTOURFITLINE_DEFAULT_DEVIATIN_FACTOR  1.8 
#define kG3D_CONTOURFITLINE_DEFAULT_SHORT_EDGE_DEVIATIN_FACTOR  2.2 
#define kG3D_CONTOURFITLINE_DEFAULT_SHORT_EDGE_CENTERLENGTH_FACTOR  0.3

typedef struct kS3dContourLineType
{
    k64f sumXX, sumXY, sumYY;
    k64s sumX, sumY, sum;
    k32s count;
    k64f a, b, c;
    k64f xm, ym;
    k64f deviation;
    k64f devSum;
    k32s devCount;
    k32s index;
    k32s newIndex;
    k32s startCos;
    k32s startSin;
    k64f maxDistance;
    k32s maxIndex;
    kBool borderLine;
    k32s borderCount;
    k64f maxValue;
    k64f devMax;
    k64f devMin;
    k64f maxLength;
    k64f minLength;
    kBool success;
    kPoint3d64f edgePoint[kG3D_STRAIGHTLINE_END];
    k32s edgeCount;
}kS3dContourLineType;

typedef struct kG3dContourFitLineClass
{
    kObjectClass base;

    kArray1 contourPoints;
    kArray1 FitMatrix;
    kArrayList polygonPoints;
    kArray1 borderProfile[kG3D_CONTOURFITLINE_BODERPOOFILE_MAX];

    k32s lineCount;
    k32s countMin;
    k32s mergeTol;
    k64f lineTol;
    k64f rectAngleTol;
    kPoint3d64f scale;
    k32s borderLineCount;
    k32s maxIndex[kG3D_CONTOURFITLINE_BODERPOOFILE_MAX];
    k32s AngleHistoCount;

    k32s imageSizeX;
    k32s imageSizeY;
    kBool borderOnly;
    kBool notUsedOnly;
    kArray2 input;

    k32s longSidePointCount;
    k32s shortSidePointCount;
    kBool longSideCenterAlgin;
    kBool shortSideCenterAlgin;
    kBool shortSideRect;

    k64f targetRotAngle;
    k64f rotCos;
    k64f rotSin;
    k32s calStep;
} kG3dContourFitLineClass;

kDeclareClassEx(kVs, kG3dContourFitLine, kObject)

kStatus kG3dContourFitLine_Init(kG3dContourFitLine fitLine, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dContourFitLine_VInitClone(kG3dContourFitLine fitLine, kG3dContourFitLine source, kAlloc allocator);
kVsFx(kSize)   kG3dContourFitLine_VSize(kG3dContourFitLine fitLine);
kVsFx(kStatus) kG3dContourFitLine_VRelease(kG3dContourFitLine fitLine);

kStatus kG3dContourFitLine_Setup(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_Calculate(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_Deviation(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_Merge(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_Expand(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_Outlier(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_Sort(kG3dContourFitLine fitLine);
kVsFx(kStatus) kG3dContourFitLine_Rescaling(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_MaximumparallelLinePair(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_FindRectangleBorderLines(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_CalculateCornerPoints(kG3dContourFitLine fitLine, kPoint3d64f* points);
kStatus kG3dContourFitLine_SearchLongSideEdgePair(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_SearchLongSideEdgePair(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_SearchShortSideEdgePair(kG3dContourFitLine fitLine);
kStatus kG3dContourFitLine_FillBorderProfile(kG3dContourFitLine fitLine, k32s index);
kStatus kG3dContourFitLine_ExpandBorderProfile(kG3dContourFitLine fitLine, k32s index);
kStatus kG3dContourFitLine_SearchEdgeGapsPoints(kG3dContourFitLine fitLine, k32s pointCount, k32s index);
kStatus kG3dContourFitLine_CenterAlgin(kG3dContourFitLine fitLine, k32s index);

#endif  /* KVISION_kG3D_CONTOURFITLINE_X_H */
