#ifndef LMITECH_KPOLYNOMIAL_H_INCLUDED
#define LMITECH_KPOLYNOMIAL_H_INCLUDED 

#include <kVision/Common/kVision.h>

typedef kObject kPolynomial;

kVsFx(kStatus) kPolynomial_Construct(kPolynomial* function, k32u order, kObject allocator);

kVsFx(kStatus) kPolynomial_Alloc(kPolynomial function, k32u order);
kVsFx(kStatus) kPolynomial_Assign(kPolynomial function, kPolynomial source); 

kVsFx(k64f) kPolynomial_Apply(kPolynomial function, k64f x);
kVsFx(kStatus) kPolynomial_ApplyN(kPolynomial function, const k64f* x, k64f* f, kSize count);

kVsFx(k32u) kPolynomial_Order(kPolynomial function);
kVsFx(k64f*) kPolynomial_Coefficients(kPolynomial function);
 
#define kPOLYNOMIAL_COEFFICIENTS(HANDLE)          kxPOLYNOMIAL_COEFFICIENTS(HANDLE)
#define kPOLYNOMIAL_ORDER(HANDLE)                 kxPOLYNOMIAL_ORDER(HANDLE)

#include <kVision/Common/kPolynomial.x.h>

#endif
