#ifndef LMITECH_KVISION_NULLMATH_H_INCLUDED
#define LMITECH_KVISION_NULLMATH_H_INCLUDED

#include <kFireSync/kFsDef.h>
#include <kVision/Common/kVision.h>
#include <kApi/Data/kArray1.h>

kVsFx(kStatus) kNullMath_Average64f(const k64f* v, kSize count, k64f* average); 
kVsFx(kStatus) kNullMath_AverageAbs64f(const k64f* v, kSize count, k64f* average);
kVsFx(kStatus) kNullMath_AbsMax64f(const k64f* v, kSize count, k64f* max);
kVsFx(kStatus) kNullMath_Max64f(const k64f* v, kSize count, k64f* max); 
kVsFx(kStatus) kNullMath_Min64f(const k64f* v, kSize count, k64f* min); 
kVsFx(kStatus) kNullMath_Stdev64f(const k64f* v, kSize count, k64f* stdev);
kVsFx(kStatus) kNullMath_StdevAbs64f(const k64f* v, kSize count, k64f* stdev);
kVsFx(kStatus) kNullMath_Add64f(const k64f* v1, const k64f* v2, k64f* vOut, kSize count);
kVsFx(kStatus) kNullMath_Sub64f(const k64f* v1, const k64f* v2, k64f* vOut, kSize count);
kVsFx(kStatus) kNullMath_SubAbs64f(const k64f* v1, const k64f* v2, k64f* vOut, kSize count);
kVsFx(kStatus) kNullMath_MulC64f(const k64f* vIn, k64f* vOut, kSize count, k64f value);
kVsFx(kStatus) kNullMath_AddC64f(const k64f* vIn, k64f* vOut, kSize count, k64f value);
kVsFx(kStatus) kNullMath_Abs64f(const k64f* vIn, k64f* vOut, kSize count);
kVsFx(kStatus) kNullMath_Sum64f(const k64f* vIn, kSize count, k64f* sum);

kVsFx(kStatus) kNullMath_StdevPoint3d64f(const kPoint3d64f* v, kSize count, kPoint3d64f* stdev);

kVsFx(kStatus) kNullMath_FindMax64f(const k64f* v, kSize count, kSize* index);
kVsFx(kStatus) kNullMath_FindMin64f(const k64f* v, kSize count, kSize* index);

kVsFx(kStatus) kNullMath_FindLongestRun64f(k64f* v, kSize count, k32u maxGap, k32u* runStart, k32u* runWidth);
kVsFx(kStatus) kNullMath_FindInterruptedRun64f(k64f* v, kSize count, k32u maxGap, k32u* runStart, k32u* runWidth);
kVsFx(kStatus) kNullMath_FindRun64f(k64f* v, kSize count, k32u* runStart, k32u* runWidth);
kVsFx(kStatus) kNullMath_ClearRuns64f(k64f* v, kSize count, k32u maxWidth);

kVsFx(k32u) kNullMath_Valid64f(const k64f* v, kSize count);

kVsFx(kStatus) kNullMath_Sub16s(const k16s* v1, const k16s* v2, k16s* vOut, kSize count);
kVsFx(kStatus) kNullMath_Add16s(const k16s* v1, const k16s* v2, k16s* vOut, kSize count);
kVsFx(kStatus) kNullMath_Average16s(const k16s* v, kSize count, k16s* avg, k64f* avgf);
kVsFx(kStatus) kNullMath_Stdev16s(const k16s* v, kSize count, k16s* stdev, k64f* stdevf);

kVsFx(kStatus) kNullMath_Sort64f_Ascending(k64f* v, kSize count);
kVsFx(kStatus) kNullMath_Sort64f_Descending(k64f* v, kSize count);
kVsFx(kStatus) kNullMath_MinPairwise64f(const k64f* v1, const k64f* v2, k64f* vOut, kSize count);
kVsFx(kStatus) kNullMath_MaxPairwise64f(const k64f* v1, const k64f* v2, k64f* vOut, kSize count);

kVsFx(kStatus) kNullMath_Median64f(k64f* input, kSize count, k64f* median);

#endif      /* #ifndef LMITECH_KVISION_NULLMATH_H_INCLUDED */

