//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus) kMatrixDirect_Invert3x3(k64f* input, k64f* output, k64f* determinant)
{
    k64f eps = 1e-12;
    k64f a = input[0];  k64f b = input[1];  k64f c = input[2];
    k64f d = input[3];  k64f e = input[4];  k64f f = input[5];
    k64f g = input[6];  k64f h = input[7];  k64f i = input[8];
    k64f det = a*(e*i - f*h) - b*(d*i - f*g) + c*(d*h - e*g);

    if (!kIsNull(determinant))   *determinant = det;

    if (kAbs_(det) < eps)
    {
        return kERROR;
    }

    output[0] = (e*i - f*h) / det;
    output[1] = (c*h - b*i) / det;
    output[2] = (b*f - c*e) / det;

    output[3] = (f*g - d*i) / det;
    output[4] = (a*i - c*g) / det;
    output[5] = (c*d - a*f) / det;

    output[6] = (d*h - e*g) / det;
    output[7] = (b*g - a*h) / det;
    output[8] = (a*e - b*d) / det;

    return kOK;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus) kMatrixDirect_Eigen(k64f* a, k64f* evec, k64f* eval, kSize n)
{
    k64f anorm, anrmx, thr, temp;
    k64f range = 1.0e-12;
    kSize i, j, k;

    anorm = 0.0;
    for (j = 0; j < n; j++)
    {
        for (i = 0; i < n; i++)
        {
            if (i != j)
            {
                anorm += a[n*j + i] * a[n*j + i];
                evec[n*j + i] = 0.0;
            }
            else
            {
                evec[n*j + i] = 1.0;
            }
        }
    }

    if (anorm > 0.0)
    {
        anorm = sqrt(anorm);
        anrmx = anorm * range / (k64f)n;
        thr = anorm;

        for (thr = anorm / (k64f)n; thr > anrmx; thr /= (k64f)n)
        {
            kBool notDone = kTRUE;
            kSize m, l;

            while (notDone)
            {
                notDone = kFALSE;
                for (l = 0; l < n - 1; l++)
                {
                    for (m = l + 1; m < n; m++)
                    {
                        kSize lm = l + m * n;
                        kSize ll = l + l * n;
                        kSize mm = m + m * n;

                        if ((a[lm] >= thr) || (-a[lm] >= thr))
                        {
                            k64f x, y, sy;
                            k64f sinx, sinx2, cosx, cosx2, sincs;

                            notDone = kTRUE;

                            x = 0.5 * (a[ll] - a[mm]);
                            y = a[lm] * a[lm] + x * x;

                            if (y <= 0.0)
                            {
                                y = -1.0;
                                sy = 0.0;
                            }
                            else
                            {
                                y = -a[lm] / sqrt(y);
                                sy = 1.0 - y * y;
                                if (sy < 0.0) sy = 0.0;
                            }

                            if (x < 0.0) y = -y;

                            sinx = y / sqrt(2.0 * (1.0 + sqrt(sy)));
                            sinx2 = sinx * sinx;
                            cosx = sqrt(1.0 - sinx2);
                            cosx2 = cosx * cosx;
                            sincs = sinx * cosx;

                            for (i = 0; i < n; i++)
                            {
                                k32s ilr, imr;

                                if ((i != l) && (i != m))
                                {
                                    kSize im = i < m ? i + m * n : m + i*n;
                                    kSize il = i < l ? i + l * n : l + i*n;
                                    k64f temp = a[il] * cosx - a[im] * sinx;

                                    a[im] = a[il] * sinx + a[im] * cosx;
                                    a[il] = temp;
                                }

                                ilr = (k32s)(n * l + i);
                                imr = (k32s)(n * m + i);
                                temp = evec[ilr] * cosx - evec[imr] * sinx;

                                evec[imr] = evec[ilr] * sinx + evec[imr] * cosx;
                                evec[ilr] = temp;
                            };

                            x = 2.0 * a[lm] * sincs;
                            y = a[ll] * cosx2 + a[mm] * sinx2 - x;
                            x = a[ll] * sinx2 + a[mm] * cosx2 + x;
                            a[lm] = (a[ll] - a[mm]) * sincs + a[lm] * (cosx2 - sinx2);
                            a[ll] = y;
                            a[mm] = x;
                        }
                    }
                }
            }
        }
    }

    /* copy eigenvalues to the output buffer */
    for (i = 0; i < n; i++)
    {
        eval[i] = a[i*n + i];
    }

    // sort eigenvalues into descending order
    for (i = 0; i < n - 1; i++)
    {
        for (j = i + 1; j < n; j++)
        {
            if (eval[i] < eval[j])
            {
                temp = eval[i];
                eval[i] = eval[j];
                eval[j] = temp;

                for (k = 0; k < n; k++)
                {
                    temp = evec[i*n + k];
                    evec[i*n + k] = evec[j*n + k];
                    evec[j*n + k] = temp;
                }
            }
        }
    }

    return kOK;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////
