#ifndef LMITECH_KXMATRIX_H_INCLUDED
#define LMITECH_KXMATRIX_H_INCLUDED

#define kMATRIX_ASSERT_64F(MATRIX)              do {kAssertType((MATRIX), kArray2); kAssert(kMATRIX_VALUE_TYPE(MATRIX) == kTypeOf(k64f));} while(0);

#define kMATRIX_VALUE_TYPE(MATRIX)              (kArray2_ItemType(MATRIX))

#define kMATRIX_DATA(MATRIX)                    (kArray2_Data(MATRIX))

#define kMATRIX_AT(MATRIX, ROW, COLUMN)         (kArray2_At((MATRIX), (ROW), (COLUMN)))

#define kMATRIX_AT_64F(MATRIX, ROW, COLUMN)     ((k64f*)kMATRIX_AT((MATRIX), (ROW), (COLUMN)))

#define kMATRIX_ROWS(MATRIX)                    (kArray2_Length((MATRIX), 0))

#define kMATRIX_COLUMNS(MATRIX)                 (kArray2_Length((MATRIX), 1))

#define kMATRIX_COUNT(MATRIX)                   (kArray2_Count(MATRIX))

#define kMATRIX_IS_SIZE_EQUAL(M1, M2)           ((kMATRIX_ROWS(M1) == kMATRIX_ROWS(M2)) && (kMATRIX_COLUMNS(M1) == kMATRIX_COLUMNS(M2)))

#endif
