#ifndef LMITECH_KMATRIX_INCLUDED_H
#define LMITECH_KMATRIX_INCLUDED_H

#include <kVision/Common/kVision.h>
#include <kApi/Data/kArray2.h>

kVsFx(void*) kMatrix_At(kArray2 matrix, kSize row, kSize column);
kVsFx(kSize) kMatrix_Rows(kArray2 matrix);
kVsFx(kSize) kMatrix_Columns(kArray2 matrix);

kVsFx(kStatus) kMatrix_Set64f(kArray2 m, k64f value);
kVsFx(kStatus) kMatrix_SetIdentity64f(kArray2 m);
kVsFx(kStatus) kMatrix_AddC64f(kArray2 mIn, kArray2 mOut, k64f value);
kVsFx(kStatus) kMatrix_SubC64f(kArray2 mIn, kArray2 mOut, k64f value);
kVsFx(kStatus) kMatrix_MulC64f(kArray2 mIn, kArray2 mOut, k64f value);
kVsFx(kStatus) kMatrix_DivC64f(kArray2 mIn, kArray2 mOut, k64f value);
kVsFx(kStatus) kMatrix_Add64f(kArray2 mIn1, kArray2 mIn2, kArray2 mOut);
kVsFx(kStatus) kMatrix_Sub64f(kArray2 mIn1, kArray2 mIn2, kArray2 mOut);
kVsFx(kStatus) kMatrix_Mul64f(kArray2 mIn1, kArray2 mIn2, kArray2 mOut);
kVsFx(kStatus) kMatrix_Solve64f(kArray2 m);
kVsFx(kStatus) kMatrix_Copy(kArray2 mIn, kArray2 mOut);
kVsFx(kStatus) kMatrix_Transpose(kArray2 mIn, kArray2 mOut);
kVsFx(kStatus) kMatrix_Invert(kArray2 mIn, kArray2 mOut, k64f* determinant);
kVsFx(kStatus) kMatrix_SolveSystem(kArray2 M, kArray2 a, kArray2 b);

#include <kVision/Common/kMatrix.x.h>

#endif 
