/** 
 * @file    kEthernetTestInfo.h
 * @brief   Declares the kEthernetTestInfo class. 
 * 
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_KETHERNET_TEST_INFO_H
#define LMITECH_KVISION_KETHERNET_TEST_INFO_H

#include <kVision/Common/kVision.h>
#include <kApi/Data/kXml.h>

typedef kObject kEthernetTestInfo; 

kVsFx(kStatus) kEthernetTestInfo_Construct(kEthernetTestInfo* info, kAlloc allocator);

kVsFx(kStatus) kEthernetTestInfo_Load(kEthernetTestInfo* info, kXml xml, kAlloc allocator);
kVsFx(kStatus) kEthernetTestInfo_Store(kEthernetTestInfo info, kXml* xml, kAlloc allocator);

kVsFx(kStatus) kEthernetTestInfo_Write(kEthernetTestInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kEthernetTestInfo_Read(kEthernetTestInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kEthernetTestInfo_Clear(kEthernetTestInfo info); 
kVsFx(kStatus) kEthernetTestInfo_Validate(kEthernetTestInfo info); 

kVsFx(k32u) kEthernetTestInfo_Port(kEthernetTestInfo info);
kVsFx(kStatus) kEthernetTestInfo_SetPort(kEthernetTestInfo info, k32u port);

kVsFx(k64u) kEthernetTestInfo_Period(kEthernetTestInfo info);
kVsFx(kStatus) kEthernetTestInfo_SetPeriod(kEthernetTestInfo info, k64u period);

kVsFx(kSize) kEthernetTestInfo_DataSize(kEthernetTestInfo info);
kVsFx(kStatus) kEthernetTestInfo_SetDataSize(kEthernetTestInfo info, kSize size);

#include <kVision/Common/kEthernetTestInfo.x.h>

#endif
