/** 
 * @file    kCpuStressTester.h
 * @brief   Declares various types used for GoMax Stress Test.
 * 
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_STRESS_TEST_H
#define LMITECH_KVISION_STRESS_TEST_H

#include <kVision/Common/kVision.h>
#include <kFireSync/Client/kNode.h>

typedef kPointer kCpuStressTester; 

kVsFx(kStatus) kCpuStressTester_Construct(kCpuStressTester* tester, kNode node, kObject allocator);

/*It's safe to restart already started test and stop non-running test*/
kVsFx(kStatus) kCpuStressTester_Start(kCpuStressTester tester);
kVsFx(kStatus) kCpuStressTester_Stop(kCpuStressTester tester);

#include <kVision/Common/kCpuStressTester.x.h>

#endif
