/** 
 * @file    kFsApi.h
 * @brief   Includes all public FireSync headers. 
 *
 * @internal
 * Copyright (C) 2012-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_API_H
#define K_FIRESYNC_API_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/kFsLib.h>
#include <kFireSync/kNodeDef.h>
#include <kFireSync/kProtocolDef.h>

#include <kFireSync/Action/kAxAction.h>
#include <kFireSync/Action/kAxEnviron.h>

#include <kFireSync/Actions/kCameraCalibrationAction.h>
#include <kFireSync/Actions/kLvdsEyeAction.h>
#include <kFireSync/Actions/kLvdsSetDelayAction.h>
#include <kFireSync/Actions/kMemoryTrafficAction.h>
#include <kFireSync/Actions/kMemoryTrafficActionInfo.h>
#include <kFireSync/Actions/kMemoryTrafficWorker.h>
#include <kFireSync/Actions/kStartAction.h>
#include <kFireSync/Actions/kStartActionInfo.h>

#include <kFireSync/Blocks/kBinCSum4Block.h>
#include <kFireSync/Blocks/kBinCSum4BlockInfo.h>
#include <kFireSync/Blocks/kForwardBlock.h>
#include <kFireSync/Blocks/kForwardBlockInfo.h>
#include <kFireSync/Blocks/kInvertBlock.h>
#include <kFireSync/Blocks/kInvertBlockInfo.h>
#include <kFireSync/Blocks/kLc250xFpnBlock.h>
#include <kFireSync/Blocks/kLc250xFpnBlockInfo.h>
#include <kFireSync/Blocks/kMemoryDomainBlock.h>
#include <kFireSync/Blocks/kMemoryDomainBlockInfo.h>
#include <kFireSync/Blocks/kMemoryTrafficBlock.h>
#include <kFireSync/Blocks/kMemoryTrafficBlockInfo.h>
#include <kFireSync/Blocks/kTimerBlock.h>
#include <kFireSync/Blocks/kTimerBlockInfo.h>

#include <kFireSync/Client/kAction.h>
#include <kFireSync/Client/kActions.h>
#include <kFireSync/Client/kAnalogOut.h>
#include <kFireSync/Client/kBlock.h>
#include <kFireSync/Client/kCamera.h>
#include <kFireSync/Client/kCameraState.h>
#include <kFireSync/Client/kDigitalOut.h>
#include <kFireSync/Client/kEncoder.h>
#include <kFireSync/Client/kEventManager.h>
#include <kFireSync/Client/kGpioBank.h>
#include <kFireSync/Client/kIoTest.h>
#include <kFireSync/Client/kLight.h>
#include <kFireSync/Client/kLightState.h>
#include <kFireSync/Client/kNet.h>
#include <kFireSync/Client/kNetInterface.h>
#include <kFireSync/Client/kNode.h>
#include <kFireSync/Client/kOrientation.h>
#include <kFireSync/Client/kPipe.h>
#include <kFireSync/Client/kPort.h>
#include <kFireSync/Client/kProjector.h>
#include <kFireSync/Client/kProjectorState.h>
#include <kFireSync/Client/kRoute.h>
#include <kFireSync/Client/kSerialOut.h>
#include <kFireSync/Client/kStorage.h>
#include <kFireSync/Client/kStorageItem.h>
#include <kFireSync/Client/kSystem.h>
#include <kFireSync/Client/kTempControl.h>
#include <kFireSync/Client/kTestJig.h>

#include <kFireSync/Client/Camera/Algorithms/kAccgd2kInfo.h>
#include <kFireSync/Client/Camera/Algorithms/kAlgInfo.h>
#include <kFireSync/Client/Camera/Algorithms/kBinCSum4Info.h>
#include <kFireSync/Client/Camera/Algorithms/kSobelwArcgdwInfo.h>
#include <kFireSync/Client/Camera/Algorithms/kSobelvAccgdwInfo.h>

#include <kFireSync/Client/Camera/Extensions/kCameraDynExp.h>
#include <kFireSync/Client/Camera/Extensions/kCameraDynFpn.h>
#include <kFireSync/Client/Camera/Extensions/kCameraExt.h>
#include <kFireSync/Client/Camera/Extensions/kCameraOverride.h>
#include <kFireSync/Client/Camera/Extensions/kCameraSteps.h>
#include <kFireSync/Client/Camera/Extensions/kCameraPhaseDecoder.h>
#include <kFireSync/Client/Camera/Extensions/kCameraTracking.h>

#include <kFireSync/Client/Light/Extensions/kLightExt.h>
#include <kFireSync/Client/Light/Extensions/kLightOverride.h>
#include <kFireSync/Client/Light/Extensions/kLightSteps.h>

#include <kFireSync/Client/Projector/Extensions/kProjectorAutoInt.h>
#include <kFireSync/Client/Projector/Extensions/kProjectorExt.h>
#include <kFireSync/Client/Projector/Extensions/kProjectorSteps.h>

#include <kFireSync/Cuda/kCuda.h>

#include <kFireSync/Data/kAlgMsg.h>
#include <kFireSync/Data/kBinCSum4Alg.h>
#include <kFireSync/Data/kBinCSumMsg.h>
#include <kFireSync/Data/kColor.h>
#include <kFireSync/Data/kCompressedPhase.h>
#include <kFireSync/Data/kCrc32.h>
#include <kFireSync/Data/kDataTree.h>
#include <kFireSync/Data/kGraphic.h>
#include <kFireSync/Data/kHealthMsg.h>
#include <kFireSync/Data/kIpp.h>
#include <kFireSync/Data/kMovingAvg.h>
#include <kFireSync/Data/kMsg.h>
#include <kFireSync/Data/kMsgInfo.h>
#include <kFireSync/Data/kMsgSet.h>
#include <kFireSync/Data/kPlot.h>
#include <kFireSync/Data/kProfileMsg.h>
#include <kFireSync/Data/kSpot.h>
#include <kFireSync/Data/kSpline.h>
#include <kFireSync/Data/kTerrain.h>
#include <kFireSync/Data/kTerrainModel.h>
#include <kFireSync/Data/kTimeAvg.h>
#include <kFireSync/Data/kUnpackedCompressedPhase.h>

#include <kFireSync/Hardware/kHxAnalogOut.h>
#include <kFireSync/Hardware/kHxCamera.h>
#include <kFireSync/Hardware/kHxCameraState.h>
#include <kFireSync/Hardware/kHxDigitalOut.h>
#include <kFireSync/Hardware/kHxEncoder.h>
#include <kFireSync/Hardware/kHxEvent.h>
#include <kFireSync/Hardware/kHxGpio.h>
#include <kFireSync/Hardware/kHxIoTest.h>
#include <kFireSync/Hardware/kHxLight.h>
#include <kFireSync/Hardware/kHxLightState.h>
#include <kFireSync/Hardware/kHxNode.h>
#include <kFireSync/Hardware/kHxNullNode.h>
#include <kFireSync/Hardware/kHxProjector.h>
#include <kFireSync/Hardware/kHxProjectorState.h>
#include <kFireSync/Hardware/kHxSerialOut.h>
#include <kFireSync/Hardware/kHxTestJig.h>

#include <kFireSync/Hardware/Camera/kHxCameraExt.h>

#include <kFireSync/Hardware/Light/kHxLightExt.h>

#include <kFireSync/Hardware/Projector/kHxProjectorExt.h>

#include <kFireSync/Health/kHealth.h>
#include <kFireSync/Health/kHealthProbe.h>
#include <kFireSync/Health/kHealthSummary.h>
#include <kFireSync/Health/kHostHealth.h>
#include <kFireSync/Health/kProfileProbe.h>

#include <kFireSync/Pipe/kPxBlock.h>
#include <kFireSync/Pipe/kPxEnviron.h>
#include <kFireSync/Pipe/kPxIoBlock.h>
#include <kFireSync/Pipe/kPxPipe.h>
#include <kFireSync/Pipe/kPxPort.h>
#include <kFireSync/Pipe/kPxParallelPipe.h>
#include <kFireSync/Pipe/kPxReplayPipe.h>
#include <kFireSync/Pipe/kPxSerialPipe.h>

#include <kFireSync/Server/kSvNode.h>

#include <kFireSync/Utils/kDateTime.h>
#include <kFireSync/Utils/kFsUtils.h>
#include <kFireSync/Utils/kHeapAlloc.h>
#include <kFireSync/Utils/kInfo.h>
#include <kFireSync/Utils/kPageCache.h>
#include <kFireSync/Utils/kTimeSpan.h>
#include <kFireSync/Utils/kSensorIdentity.h>
#include <kFireSync/Utils/kStorageStream.h>

#endif
