/** 
 * @file    kSensorIdentity.x.h
 * @brief   Defines field names for Id.xml.
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_SENSOR_IDENTITY_X_H
#define K_FIRESYNC_SENSOR_IDENTITY_X_H

/**
 * Schema version of SensorIdentity class.
 *
 * @relates     kSensorIdentity
 * @{ */
#define kSENSOR_IDENTITY_VERSION                (3)
#define kSENSOR_IDENTITY_VERSION_ATTRIBUTE      "schemaVersion"
/** @} */

/**
 * Core field names for the SensorIdentity class.
 *
 * Modifying existing fields may break compatability
 * with Factory and Gocator firmware.
 *
 * @relates     kSensorIdentity
 * @{ */
#define kSENSOR_IDENTITY_HEADER                     "Identity"
#define kSENSOR_IDENTITY_PART_NUMBER                "PartNumber"
#define kSENSOR_IDENTITY_SERIAL_NUMBER              "SerialNumber"
#define kSENSOR_IDENTITY_CLASS                      "Class"
#define kSENSOR_IDENTITY_MODEL                      "Model"
#define kSENSOR_IDENTITY_MODEL_NUMBER               "ModelNumber"
#define kSENSOR_IDENTITY_LASER_CLASS                "LaserClass"
#define kSENSOR_IDENTITY_SPECTRUM                   "Spectrum"
#define kSENSOR_IDENTITY_PACKAGE                    "Package"
#define kSENSOR_IDENTITY_HARDWARE_REVISION          "HardwareRevision"
#define kSENSOR_IDENTITY_FIRMWARE_VERSION           "Version"
#define kSENSOR_IDENTITY_COMPATIBLE_FIRMWARE_TAG    "CompatibleFirmwareTag"
#define kSENSOR_IDENTITY_IS_CONTROL                 "IsControl"
#define kSENSOR_IDENTITY_OPTION_CODE                "OptionCode"
/** @} */

/**
 * Custom field names for the SensorIdentity class.
 *
 * Private or temporary field names to be defined here
 * to avoid duplicity.
 *
 * @relates     kSensorIdentity
 * @{ */
#define kSENSOR_IDENTITY_MIN_FIRMWARE_VERSION       "MinFirmwareVersion"
#define kSENSOR_IDENTITY_CLEARANCE_DISTANCE         "ClearanceDistance"
/** @} */

typedef struct kSensorIdentityClass 
{
    kObjectClass base;

    k32u version; // schema version
    kArrayList fields[2]; // maps field names to values - kArrayList fields[kString fieldName, kString fieldValue]

} kSensorIdentityClass;

kDeclareClassEx(kFs, kSensorIdentity, kObject) 

kFsFx(kStatus) xkSensorIdentity_ConstructFramework(kSensorIdentity* identity, kAlloc allocator);
kFsFx(kStatus) xkSensorIdentity_InitFramework(kSensorIdentity identity, kType type, kAlloc alloc);

kFsFx(kStatus) kSensorIdentity_Init(kSensorIdentity identity, kAlloc allocator);
kFsFx(kStatus) kSensorIdentity_VClone(kSensorIdentity identity, kSensorIdentity source, kAlloc valueAlloc, kObject context);
kFsFx(kBool)   kSensorIdentity_VEquals(kSensorIdentity identity, kSensorIdentity otherIdentity);
kFsFx(kStatus) kSensorIdentity_VRelease(kSensorIdentity identity);

kFsFx(kStatus) kSensorIdentity_Find(kSensorIdentity identity, const kChar* fieldName, kString* fieldValue);
kFsFx(kStatus) kSensorIdentity_Replace(kSensorIdentity identity, const kChar* fieldName, const kChar* fieldValue);

kStatus kSensorIdentity_FromXmlRecursive(kSensorIdentity identity, kXml xml, kXmlItem node, const kChar* parentName);

#endif      /* #ifndef K_FIRESYNC_SENSOR_IDENTITY_X_H */
