/** 
 * @file    kPlRangeLut.h
 * @brief   Utility functions.
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_RANGE_LUT_UTILS_H
#define K_FIRESYNC_RANGE_LUT_UTILS_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kPlRangeLut
 * @ingroup kFireSync-Utils
 * @brief   Collection of FPGA Lut functions. 
 */

/** 
 * Loads a test pattern
 *
 * @public                  @memberof kPlRangeLut
 * @param   camera          Camera object. 
 * @param   reduceStep      Uses reduced step size.
 * @param   enableOffset    Uses full image height.
 * @param   decimate        Uses decimation. 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kPlRangeLut_SetRampPattern(kCamera camera, kBool reduceStep, kBool enableOffset, kBool decimate);

#include <kFireSync/Utils/kPlRangeLut.x.h>

#endif
