/** 
 * @file    kPageCache.x.h
 *
 * @internal
 * Copyright (C) 2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PAGE_CACHE_X_H
#define K_FIRESYNC_PAGE_CACHE_X_H

#include <kApi/Data/kList.h>

typedef struct kPageCacheEntry
{
    kPointer data;                  //Pointer to cached data; length equal to page size.
    kPointer spare;                 //Pointer to cached spare; length equal per-page spare size.
    kListItem lruListItem;          //Reference to LRU list entry for the page.
} kPageCacheEntry;

kDeclareValueEx(kFs, kPageCacheEntry, kValue)

typedef struct kPageCacheClass
{
    kObjectClass base; 

    kSize pageCapacity;             //Maximum count of pages to be cached.
    kSize pageSize;                 //Cache entry page size.
    kSize spareSize;                //Cache entry spare size.

    kArray1 content;                //The actual memory allocated for cache pages -- kArray1<kPageCacheEntry>
    kMap pageMap;                   //Maps from page index to cache item (pointer to an item in the content array)-- kMap<kSize, kPageCacheEntry*>
    kList lruList;                  //List of cache page indices, sorted from least recently used to most recently used -- kList<kSize>
    kQueue freeQueue;               //Queue of free cache pages -- kQueue<kPageCacheEntry*>

} kPageCacheClass; 

kDeclareClassEx(kFs, kPageCache, kObject)
       
kFsFx(kStatus) xkPageCache_Init(kPageCache cache, kType type, kSize pageCapacity, kSize pageSize, kSize spareSize, kAlloc alloc); 
kFsFx(kStatus) xkPageCache_VRelease(kPageCache cache); 

kFsFx(kStatus) xkPageCache_Allocate(kPageCache cache);
kFsFx(kStatus) xkPageCache_Free(kPageCache cache);

kFsFx(kStatus) xkPageCache_AllocateCachePage(kPageCache cache, kSize pageIndex, kPageCacheEntry** page);

kFsFx(kStatus) xkPageCache_TouchPage(kPageCache cache, kSize pageIndex, kPageCacheEntry* entry);

kFsFx(kStatus) xkPageCache_InvalidateLeastRecent(kPageCache cache);

#endif
