/** 
 * @file    kInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_INFO_X_H
#define K_FIRESYNC_INFO_X_H

kDeclareEnumEx(kFs, kViolation, kValue)

kDeclareValueEx(kFs, kInfo, kValue)
kDeclareValueEx(kFs, kInfo32u, kValue)
kDeclareValueEx(kFs, kInfo32s, kValue)
kDeclareValueEx(kFs, kInfo64u, kValue)
kDeclareValueEx(kFs, kInfo64s, kValue)
kDeclareValueEx(kFs, kInfo64f, kValue)
kDeclareValueEx(kFs, kInfoSize, kValue)
kDeclareValueEx(kFs, kInfoBool, kValue)
kDeclareValueEx(kFs, kInfoBits, kValue)

template <typename I, typename T>
T xkAdjustInfoValue(const I& info, const T& value, kAdjust style)
{
    switch (style)
    {
        case kADJUST_RELATIVE_FLOOR: return kAdjustFloor(value, info.relativeMin, info.relativeMax, info.granularity); 
        case kADJUST_RELATIVE_CEIL:  return kAdjustCeil(value, info.relativeMin, info.relativeMax, info.granularity); 
        case kADJUST_ABSOLUTE_FLOOR: return kAdjustFloor(value, info.absoluteMin, info.absoluteMax, info.granularity); 
        case kADJUST_ABSOLUTE_CEIL:  return kAdjustCeil(value, info.absoluteMin, info.absoluteMax, info.granularity); 
        default:                     return value;
    }
}

#endif
