/** 
 * @file    kSvHealthOutNet.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_HEALTH_OUT_NET_X_H
#define K_FIRESYC_SERVER_HEALTH_OUT_NET_X_H

#include <kFireSync/Server/Network/kSvHealthOutChannel.h>

#define kSV_HEALTH_OUT_NET_QUEUE_CAPACITY              (100)            ///< Max count of enqueued output messages. 

#define kSV_HEALTH_OUT_NET_QUIT_QUERY_PERIOD           (100000)         ///< Polling interval for quit (stop) status (us). 

#define kSV_HEALTH_OUT_NET_CMD_QUERY_PERIOD            (100000)         ///< Time to wait for compression command after connection is established (us). 


typedef struct kSvHealthOutNetClass
{
    kSvHealthOutChannelClass base; 
    
    kTcpClient client;                  //Client connection. 
    kSerializer serializer;             //Message serializer. 

    kThread thread;                     //Thread to service client.

    kMsgQueue messageQueue;             //Messages to be sent -- kMsgQueue<kObject>. 

    kAtomic32s shouldQuit;              //Is the channel stopping?
    kAtomic32s hasExited;               //Is the channel still accepting commands?

    kBool compressionEnabled;           //Is compression enabled?

    k16u nextGuid;                      //Next available GUID.
    kMap healthGuidMap;                 //Map of health state name to unique id.
    kMap profileGuidMap;                //Map of profile state name to unique id.
    kMap previousHealthIndicators;      //Previous list of health indicators.
    kMap nextHealthIndicators;          //Next list of health indicators.
    kMap previousProfileIndicators;     //Previous list of profile indicators.
    kMap nextProfileIndicators;         //Next list of profile indicators.

} kSvHealthOutNetClass; 

kDeclareClassEx(kFs, kSvHealthOutNet, kSvHealthOutChannel)
        
kFsFx(kStatus) kSvHealthOutNet_Init(kSvHealthOutNet channel, kType type, kSvHealthOut service, kTcpClient client, kAlloc alloc); 
kFsFx(kStatus) kSvHealthOutNet_VRelease(kSvHealthOutNet channel);

kFsFx(kStatus) kSvHealthOutNet_ThreadEntry(kSvHealthOutNet channel); 

kFsFx(kBool) kSvHealthOutNet_ReadChannelConfiguration(kSvHealthOutNet channel);

kFsFx(kStatus) kSvHealthOutNet_WriteCompressed(kSvHealthOutNet channel, kObject message);
kFsFx(kStatus) kSvHealthOutNet_WriteCompressedHealth(kSvHealthOutNet channel, kHealthMsg message);
kFsFx(kStatus) kSvHealthOutNet_WriteCompressedProfile(kSvHealthOutNet channel, kProfileMsg message);
kFsFx(kStatus) kSvHealthOutNet_WriteObject(kSvHealthOutNet channel, kProfileMsg message);

kFsFx(kStatus) kSvHealthOutNet_SendUpdateIndicatorMsg(kSvHealthOutNet channel, k16u guid, k64s diff);
kFsFx(kStatus) kSvHealthOutNet_HealthGuid(kSvHealthOutNet channel, const kText64 name, k16u* guid);
kFsFx(kStatus) kSvHealthOutNet_ProfileGuid(kSvHealthOutNet channel, const kText64 name, k16u* guid);

kFsFx(kStatus) kSvHealthOutNet_VSend(kSvHealthOutNet channel, kObject info);
kFsFx(kBool) kSvHealthOutNet_VIsActive(kSvHealthOutNet channel);

#endif
