/** 
 * @file    kSvHealthOutApp.h
 * @brief   Declares the kSvHealthOutApp class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_HEALTH_OUT_APP_H
#define K_FIRESYC_SERVER_HEALTH_OUT_APP_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvHealthOutApp
 * @extends kSvHealthOutChannel
 * @ingroup kFireSync-Server-Network
 * @brief   Represents the server side of a local health connection (supports kSvNode implementation of kNodeProvider). 
 */
//typedef kSvHealthOutChannel kSvHealthOutApp;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvHealthOutApp object.
 *
 * @public                  @memberof kSvHealthOutApp
 * @param   channel         Destination for the constructed object handle. 
 * @param   service         Health output service (parent). 
 * @param   function        Callback function to receive messages. 
 * @param   receiver        Context for receive callback.  
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kSvHealthOutApp_Construct(kSvHealthOutApp* channel, kSvHealthOut service, kCallbackFx function, kPointer receiver, kAlloc allocator);

#include <kFireSync/Server/Network/kSvHealthOutApp.x.h>

#endif
